/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.annotations;

import java.util.Collection;
import java.util.List;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.annotations.AnnotationProcessor;
import org.apache.felix.scrplugin.annotations.ClassAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedClass;
import org.apache.felix.scrplugin.description.AbstractDescription;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentConfigurationPolicy;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.PropertyUnbounded;
import org.apache.felix.scrplugin.description.ServiceDescription;
import org.apache.sling.hc.annotations.SlingHealthCheck;
import org.apache.sling.hc.api.HealthCheck;

public class SlingHealthCheckProcessor
implements AnnotationProcessor {
    public void process(ScannedClass scannedClass, ClassDescription classDescription) throws SCRDescriptorException, SCRDescriptorFailureException {
        List healthChecks = scannedClass.getClassAnnotations(SlingHealthCheck.class.getName());
        scannedClass.processed((Collection)healthChecks);
        for (ClassAnnotation cad : healthChecks) {
            this.processHealthCheck(cad, classDescription);
        }
    }

    private void processHealthCheck(ClassAnnotation cad, ClassDescription classDescription) {
        String warningsStickForMinutesPropName;
        boolean generateService;
        boolean generateComponent = cad.getBooleanValue("generateComponent", true);
        boolean metatype = cad.getBooleanValue("metatype", true);
        boolean immediate = cad.getBooleanValue("immediate", false);
        if (generateComponent) {
            String nameOfAnnotatedClass = classDescription.getDescribedClass().getName();
            ComponentDescription cd = new ComponentDescription((ScannedAnnotation)cad);
            cd.setName(cad.getStringValue("componentName", nameOfAnnotatedClass));
            cd.setConfigurationPolicy(ComponentConfigurationPolicy.valueOf((String)cad.getEnumValue("configurationPolicy", ComponentConfigurationPolicy.OPTIONAL.name())));
            cd.setSetMetatypeFactoryPid(cad.getBooleanValue("configurationFactory", false));
            String nameFromAnnotation = (String)cad.getValue("name");
            String defaultLabel = "Sling Health Check: " + (nameFromAnnotation != null ? nameFromAnnotation : nameOfAnnotatedClass);
            cd.setLabel(cad.getStringValue("label", defaultLabel));
            cd.setDescription(cad.getStringValue("description", "Health Check Configuration"));
            cd.setCreateMetatype(metatype);
            cd.setImmediate(Boolean.valueOf(immediate));
            classDescription.add((AbstractDescription)cd);
        }
        if (generateService = cad.getBooleanValue("generateService", true)) {
            ServiceDescription sd = new ServiceDescription((ScannedAnnotation)cad);
            sd.addInterface(HealthCheck.class.getName());
            classDescription.add((AbstractDescription)sd);
        }
        this.generatePropertyDescriptor(cad, classDescription, metatype, "name", "hc.name", PropertyType.String, "Name", "Name of the Health Check", false);
        this.generatePropertyDescriptor(cad, classDescription, metatype, "tags", "hc.tags", PropertyType.String, "Tags", "List of tags", true);
        this.generatePropertyDescriptor(cad, classDescription, metatype, "mbeanName", "hc.mbean.name", PropertyType.String, "MBean", "MBean name (leave empty for not using JMX)", false);
        this.generatePropertyDescriptor(cad, classDescription, metatype, "asyncCronExpression", "hc.async.cronExpression", PropertyType.String, "Cron expression", "Cron expression for asynchronous execution (leave empty for synchronous execution)", false);
        String resultCacheTtlInMsPropName = "resultCacheTtlInMs";
        if (cad.getValue(resultCacheTtlInMsPropName) != null) {
            this.generatePropertyDescriptor(cad, classDescription, metatype, resultCacheTtlInMsPropName, "hc.resultCacheTtlInMs", PropertyType.Long, "Result Cache TTL", "TTL for results. The value -1 (default) uses the global configuration in health check executor. Redeployment of a HC always invalidates its cached result.", false);
        }
        if (cad.getValue(warningsStickForMinutesPropName = "warningsStickForMinutes") != null) {
            this.generatePropertyDescriptor(cad, classDescription, metatype, warningsStickForMinutesPropName, "hc.warningsStickForMinutes", PropertyType.Long, "Sticky Warnings", "If given, warning results (that is WARN,  CRITICAL or HEALTH_CHECK_ERROR) from the past executions will be taken into account as well for the given minutes (use  Integer.MAX_VALUE for indefinitely). By default this is disabled (value -1).", false);
        }
    }

    private boolean isLongDefaultValue(ClassAnnotation cad, String propName) {
        Object value = cad.getValue(propName);
        return value == null || (Long)value == -1L;
    }

    private void generatePropertyDescriptor(ClassAnnotation cad, ClassDescription classDescription, boolean metatype, String propertyName, String propertyDescriptorName, PropertyType propertyType, String label, String description, boolean isArray) {
        PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
        pd.setName(propertyDescriptorName);
        pd.setLabel(label);
        pd.setDescription(description);
        pd.setType(propertyType);
        if (isArray) {
            String[] values = (String[])cad.getValue(propertyName);
            pd.setMultiValue(values);
            pd.setUnbounded(PropertyUnbounded.ARRAY);
            pd.setCardinality(Integer.MAX_VALUE);
        } else {
            Object propertyVal = cad.getValue(propertyName);
            String pdValue = propertyVal instanceof String ? (String)propertyVal : (propertyVal != null ? propertyVal.toString() : null);
            pd.setValue(pdValue);
            pd.setUnbounded(PropertyUnbounded.DEFAULT);
        }
        if (!metatype) {
            pd.setPrivate(Boolean.valueOf(true));
        }
        classDescription.add((AbstractDescription)pd);
    }

    public int getRanking() {
        return 500;
    }

    public String getName() {
        return SlingHealthCheck.class.getName() + " annotation processor.";
    }
}

