/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.Section;
import org.apache.sling.provisioning.model.io.ModelReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoinitTextProvider {
    private static final String DEFAULT_MODEL_SECTION = "repoinit";
    public static final Pattern REF_PATTERN = Pattern.compile("([a-z]+)(@([a-zA-Z0-9_-]+))?:(.*)");
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public String getRepoinitText(String referenceString) throws IOException {
        Reference ref = new Reference(referenceString);
        this.log.info("Reading repoinit statements from {}", (Object)ref);
        String rawText = this.getRawText(ref.url);
        this.log.debug("Raw text from {}: \n{}", (Object)ref.url, (Object)rawText);
        if (TextFormat.MODEL.equals((Object)ref.format)) {
            this.log.debug("Extracting provisioning model section {}", (Object)ref.modelSection);
            return this.extractFromModel(ref.url, rawText, ref.modelSection);
        }
        return rawText;
    }

    private String extractFromModel(String sourceInfo, String rawText, String modelSection) throws IOException {
        StringReader reader = new StringReader(rawText);
        Model model = ModelReader.read((Reader)reader, (String)sourceInfo);
        StringBuilder sb = new StringBuilder();
        if (modelSection == null) {
            throw new IllegalStateException("Model section name is null, cannot read model");
        }
        for (Feature feature : model.getFeatures()) {
            for (Section section : feature.getAdditionalSections(modelSection)) {
                sb.append("# ").append(modelSection).append(" from ").append(feature.getName()).append("\n");
                sb.append("# ").append(section.getComment()).append("\n");
                sb.append(section.getContents()).append("\n");
            }
        }
        return sb.toString();
    }

    private String getRawText(String urlString) throws IOException {
        String result = "";
        URL url = new URL(urlString);
        URLConnection c = url.openConnection();
        InputStream is = c.getInputStream();
        if (is == null) {
            this.log.warn("Cannot get InputStream for {}", (Object)url);
        } else {
            StringWriter w = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)w, (Charset)StandardCharsets.UTF_8);
            result = w.toString();
        }
        return result;
    }

    static class Reference {
        final TextFormat format;
        final String modelSection;
        final String url;

        Reference(String ref) {
            if (ref == null) {
                throw new IllegalArgumentException("Null reference");
            }
            Matcher m = REF_PATTERN.matcher(ref);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid reference '" + ref + "', should match " + REF_PATTERN);
            }
            this.format = TextFormat.fromType(m.group(1));
            this.modelSection = this.format.equals((Object)TextFormat.RAW) ? null : (this.format.equals((Object)TextFormat.MODEL) && m.group(3) == null ? RepoinitTextProvider.DEFAULT_MODEL_SECTION : m.group(3));
            this.url = m.group(4);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append(":");
            sb.append("format=").append((Object)this.format);
            if (this.modelSection != null) {
                sb.append(", model section=").append(this.modelSection);
            }
            sb.append(", URL=").append(this.url);
            return sb.toString();
        }
    }

    public static enum TextFormat {
        RAW("raw"),
        MODEL("model");

        private String type;

        private TextFormat(String type) {
            this.type = type;
        }

        public static TextFormat fromType(String v) {
            Optional<TextFormat> findFirst = Stream.of(TextFormat.values()).filter(tf -> tf.type.equals(v)).findFirst();
            if (!findFirst.isPresent()) {
                throw new IllegalArgumentException("Value not found: " + v);
            }
            return findFirst.get();
        }

        public String toString() {
            return this.type;
        }
    }
}

