/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.bundle.tracker.internal;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.script.SimpleBindings;

class LazyBindings
extends SimpleBindings {
    private final Map<String, Supplier<Object>> suppliers;

    LazyBindings(Map<String, Supplier<Object>> suppliers) {
        this.suppliers = suppliers;
    }

    @Override
    public Object get(Object key) {
        if (!super.containsKey(key) && this.suppliers.containsKey(key)) {
            Object value = this.suppliers.get(key).get();
            this.put((String)key, value);
        }
        return super.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.suppliers.containsKey(key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>(super.entrySet());
        for (Map.Entry<String, Supplier<Object>> supplierEntry : this.suppliers.entrySet()) {
            entrySet.add(new AbstractMap.SimpleEntry<String, Object>(supplierEntry.getKey(), supplierEntry.getValue().get()));
        }
        return Collections.unmodifiableSet(entrySet);
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>(super.keySet());
        if (!this.suppliers.isEmpty()) {
            keySet.addAll(this.suppliers.keySet());
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        if (!super.containsKey(key) && this.suppliers.containsKey(key)) {
            Object value = this.suppliers.get(key).get();
            this.put((String)key, value);
        }
        return super.getOrDefault(key, defaultValue);
    }
}

