/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.resolver.internal.ScriptResourceResolver;
import org.apache.sling.servlets.resolver.internal.resource.MergingServletResourceProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ScriptResourceDecorator
implements ResourceDecorator {
    private final MergingServletResourceProvider provider;

    @Activate
    public ScriptResourceDecorator(@Reference MergingServletResourceProvider provider) {
        this.provider = provider;
    }

    public Resource decorate(Resource resource) {
        String path = ResourceUtil.normalize((String)resource.getPath());
        if (this.provider.isRootOf(path)) {
            int idx;
            String resolutionPath = resource.getResourceMetadata().getResolutionPath();
            Resource script = this.getResource(resource, path);
            if (script == resource && "sling:nonexisting".equals(resource.getResourceType()) && (idx = path.indexOf(46)) != -1) {
                path = path.substring(0, idx);
                script = this.getResource(resource, path);
                resolutionPath = path;
            }
            if (script != resource) {
                script.getResourceMetadata().putAll((Map)resource.getResourceMetadata());
                script.getResourceMetadata().setResolutionPath(resolutionPath);
            }
            return script;
        }
        return resource;
    }

    public Resource decorate(Resource resource, HttpServletRequest request) {
        return this.decorate(resource);
    }

    private Resource getResource(final Resource resource, String path) {
        return this.provider.getResource((ResolveContext)new ResolveContext<Void>(){

            public ResourceResolver getResourceResolver() {
                return new ScriptResourceResolver(resource.getResourceResolver(), () -> ScriptResourceDecorator.this.provider);
            }

            public Void getProviderState() {
                return null;
            }

            public ResolveContext<?> getParentResolveContext() {
                return null;
            }

            public ResourceProvider<?> getParentResourceProvider() {
                return new ResourceProvider<Object>(){

                    public Resource getResource(ResolveContext<Object> ctx, String path, ResourceContext resourceContext, Resource parent) {
                        return resource;
                    }

                    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
                        return null;
                    }
                };
            }
        }, path);
    }
}

