/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api.jmx;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.jmx.Description;
import org.apache.jackrabbit.oak.api.jmx.Name;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface IndexStatsMBean {
    public static final String TYPE = "IndexStats";
    public static final String STATUS_INIT = "init";
    public static final String STATUS_RUNNING = "running";
    public static final String STATUS_DONE = "done";
    public static final String STATUS_FAILING = "failing";
    public static final String STATUS_INTERRUPTED = "interrupted";

    public String getName();

    public String getStart();

    public String getDone();

    public String getStatus();

    public String getLastIndexedTime();

    public void pause();

    @Description(value="Aborts any running indexing cycle and pauses the indexer. Invoke 'resume' once you are read to resume indexing again")
    public String abortAndPause();

    @Description(value="Release lease for a paused lane")
    public String releaseLeaseForPausedLane();

    public void resume();

    public boolean isPaused();

    public long getUpdates();

    public long getNodesReadCount();

    public String getReferenceCheckpoint();

    @Description(value="Force update the indexing lane to a checkpoint created during execution of this function. This will abort and pause the running lane, release it's lease and set the reference checkpoint to a latest one.Any content changes between the old reference checkpoint and the new one will be not be indexed and a reindexing would be required.Only use this operation if you are sure that the lane is stuck and not updated since many days and cannot catch up on its own.Once this operation is completed, reindexing for all indexes on the lane is required.")
    public String forceIndexLaneCatchup(@Name(value="Confirmation Message") @Description(value="Enter 'CONFIRM' to confirm the operation") String var1) throws CommitFailedException;

    public String getProcessedCheckpoint();

    public String getTemporaryCheckpoints();

    public long getTotalExecutionCount();

    public CompositeData getExecutionCount();

    @Deprecated
    public CompositeData getExecutionTime();

    public CompositeData getIndexedNodesCount();

    public CompositeData getConsolidatedExecutionStats();

    @Deprecated
    public void resetConsolidatedExecutionStats();

    public void splitIndexingTask(@Name(value="paths") @Description(value="Comma separated list of paths of the index definitions") String var1, @Name(value="newIndexTaskName") @Description(value="The indexing task name set on the async property") String var2);

    public void registerAsyncIndexer(@Name(value="name") String var1, @Name(value="delayInSeconds") long var2);

    public boolean isFailing();

    public String getFailingSince();

    public long getConsecutiveFailedExecutions();

    public String getLatestError();

    public String getLatestErrorTime();

    public TabularData getFailingIndexStats();
}

