/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.tracer.internal.Configuration;
import org.apache.sling.tracer.internal.Recording;
import org.apache.sling.tracer.internal.TraceLogRecorder;
import org.apache.sling.tracer.internal.TracerConfig;
import org.apache.sling.tracer.internal.TracerContext;
import org.apache.sling.tracer.internal.TracerLogServlet;
import org.apache.sling.tracer.internal.TracerSet;
import org.apache.sling.tracer.internal.Util;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class LogTracer {
    public static final String PARAM_TRACER = "tracers";
    public static final String PARAM_TRACER_CONFIG = "tracerConfig";
    public static final String HEADER_TRACER_CONFIG = "Sling-Tracer-Config";
    public static final String HEADER_TRACER = "Sling-Tracers";
    private static final Logger LOG = LoggerFactory.getLogger(LogTracer.class);
    private final Map<String, TracerSet> tracers = new HashMap<String, TracerSet>();
    private BundleContext bundleContext;
    private ServiceRegistration slingFilterRegistration;
    private ServiceRegistration filterRegistration;
    private final AtomicReference<ServiceRegistration> logCollectorReg = new AtomicReference();
    private final AtomicInteger logCollectorRegCount = new AtomicInteger();
    private static final ThreadLocal<TracerContext> requestContextHolder = new ThreadLocal();
    @Nullable
    private TracerLogServlet logServlet;
    private TraceLogRecorder recorder = TraceLogRecorder.DEFAULT;

    @Activate
    private void activate(Configuration config, BundleContext context) {
        this.bundleContext = context;
        this.initializeTracerSet(config);
        boolean enabled = config.enabled();
        if (enabled) {
            this.registerFilters(context);
            boolean servletEnabled = config.servletEnabled();
            if (servletEnabled) {
                int cacheSize = config.recordingCacheSizeInMB();
                long cacheDuration = config.recordingCacheDurationInSecs();
                boolean compressionEnabled = config.recordingCompressionEnabled();
                boolean gzipResponse = config.gzipResponse();
                this.logServlet = new TracerLogServlet(context, cacheSize, cacheDuration, compressionEnabled, gzipResponse);
                this.recorder = this.logServlet;
                LOG.info("Tracer recoding enabled with cacheSize {} MB, expiry {} secs, compression {}, gzip response {}", new Object[]{cacheSize, cacheDuration, compressionEnabled, gzipResponse});
            }
            LOG.info("Log tracer enabled. Required filters registered. Tracer servlet enabled {}", (Object)servletEnabled);
        }
    }

    @Deactivate
    private void deactivate() {
        ServiceRegistration reg;
        if (this.logServlet != null) {
            this.logServlet.unregister();
        }
        if (this.slingFilterRegistration != null) {
            this.slingFilterRegistration.unregister();
            this.slingFilterRegistration = null;
        }
        if (this.filterRegistration != null) {
            this.filterRegistration.unregister();
            this.filterRegistration = null;
        }
        if ((reg = (ServiceRegistration)this.logCollectorReg.getAndSet(null)) != null) {
            reg.unregister();
        }
        requestContextHolder.remove();
    }

    TracerContext getTracerContext(String tracerSetNames, String tracerConfig, Recording recording) {
        tracerConfig = Util.trimToNull(tracerConfig);
        if ((tracerSetNames = Util.trimToNull(tracerSetNames)) == null && tracerConfig == null) {
            return null;
        }
        ArrayList<TracerConfig> configs = new ArrayList<TracerConfig>();
        ArrayList<String> invalidNames = new ArrayList<String>();
        if (tracerSetNames != null) {
            for (String tracerSetName : tracerSetNames.split(",")) {
                TracerSet ts = this.tracers.get(tracerSetName.toLowerCase(Locale.ENGLISH));
                if (ts != null) {
                    configs.addAll(ts.getConfigs());
                    continue;
                }
                invalidNames.add(tracerSetName);
            }
        }
        if (!invalidNames.isEmpty()) {
            LOG.warn("Invalid tracer set names passed [{}] as part of [{}]", invalidNames, (Object)tracerSetNames);
        }
        if (tracerConfig != null) {
            TracerSet ts = new TracerSet("custom", tracerConfig);
            configs.addAll(ts.getConfigs());
        }
        return new TracerContext(configs.toArray(new TracerConfig[configs.size()]), recording);
    }

    private void initializeTracerSet(Configuration config) {
        for (String tracerSetConfig : config.tracerSets()) {
            TracerSet tc = new TracerSet(tracerSetConfig);
            this.tracers.put(tc.getName(), tc);
        }
    }

    private void registerFilters(BundleContext context) {
        Hashtable<String, String> slingFilterProps = new Hashtable<String, String>();
        ((Dictionary)slingFilterProps).put("sling.filter.scope", "REQUEST");
        ((Dictionary)slingFilterProps).put("service.description", "Sling Filter required for Log Tracer");
        this.slingFilterRegistration = context.registerService(Filter.class.getName(), (Object)new SlingTracerFilter(), slingFilterProps);
        Hashtable<String, String> filterProps = new Hashtable<String, String>();
        ((Dictionary)filterProps).put("pattern", "/.*");
        ((Dictionary)filterProps).put("osgi.http.whiteboard.filter.pattern", "/");
        ((Dictionary)filterProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=*)");
        ((Dictionary)filterProps).put("service.description", "Servlet Filter required for Log Tracer");
        this.filterRegistration = context.registerService(Filter.class.getName(), (Object)new TracerFilter(), filterProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLogCollector() {
        AtomicInteger atomicInteger = this.logCollectorRegCount;
        synchronized (atomicInteger) {
            int count = this.logCollectorRegCount.getAndIncrement();
            if (count == 0) {
                ServiceRegistration reg = this.bundleContext.registerService(TurboFilter.class.getName(), (Object)new LogCollector(), null);
                this.logCollectorReg.set(reg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterLogCollector() {
        AtomicInteger atomicInteger = this.logCollectorRegCount;
        synchronized (atomicInteger) {
            int count = this.logCollectorRegCount.decrementAndGet();
            if (count == 0) {
                ServiceRegistration reg = this.logCollectorReg.getAndSet(null);
                reg.unregister();
            }
        }
    }

    private static class LogCollector
    extends TurboFilter {
        private LogCollector() {
        }

        public FilterReply decide(Marker marker, ch.qos.logback.classic.Logger logger, Level level, String format, Object[] params, Throwable t) {
            TracerContext tracer = (TracerContext)requestContextHolder.get();
            if (tracer == null) {
                return FilterReply.NEUTRAL;
            }
            tracer.recordCategory(logger.getName());
            TracerConfig tc = tracer.findMatchingConfig(logger.getName(), level);
            if (tc != null) {
                if (format == null) {
                    return FilterReply.ACCEPT;
                }
                if (tracer.log(tc, level, logger.getName(), format, params)) {
                    return FilterReply.ACCEPT;
                }
            }
            return FilterReply.NEUTRAL;
        }
    }

    private class SlingTracerFilter
    extends AbstractFilter {
        private SlingTracerFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)servletRequest;
            TracerContext tracerContext = (TracerContext)requestContextHolder.get();
            Recording recording = LogTracer.this.recorder.getRecordingForRequest((HttpServletRequest)slingRequest);
            recording.registerTracker(slingRequest.getRequestProgressTracker());
            boolean createdContext = false;
            if (tracerContext == null && (tracerContext = LogTracer.this.getTracerContext(slingRequest.getParameter(LogTracer.PARAM_TRACER), slingRequest.getParameter(LogTracer.PARAM_TRACER_CONFIG), recording)) != null) {
                createdContext = true;
            }
            try {
                if (tracerContext != null) {
                    tracerContext.registerProgressTracker(slingRequest.getRequestProgressTracker());
                    if (createdContext) {
                        this.enableCollector(tracerContext);
                    }
                }
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                if (tracerContext != null) {
                    tracerContext.done();
                    if (createdContext) {
                        this.disableCollector();
                    }
                }
            }
        }
    }

    private class TracerFilter
    extends AbstractFilter {
        private TracerFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            Recording recording = LogTracer.this.recorder.startRecording(httpRequest, (HttpServletResponse)servletResponse);
            TracerContext tracerContext = LogTracer.this.getTracerContext(httpRequest.getHeader(LogTracer.HEADER_TRACER), httpRequest.getHeader(LogTracer.HEADER_TRACER_CONFIG), recording);
            try {
                if (tracerContext != null) {
                    this.enableCollector(tracerContext);
                }
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                if (tracerContext != null) {
                    this.disableCollector();
                }
                LogTracer.this.recorder.endRecording(httpRequest, recording);
            }
        }
    }

    private abstract class AbstractFilter
    implements Filter {
        private AbstractFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }

        protected void enableCollector(TracerContext tracerContext) {
            requestContextHolder.set(tracerContext);
            LogTracer.this.registerLogCollector();
        }

        protected void disableCollector() {
            requestContextHolder.remove();
            LogTracer.this.unregisterLogCollector();
        }
    }
}

