/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.validators;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.validation.SlingValidationException;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.spi.Validator;
import org.apache.sling.validation.spi.ValidatorContext;
import org.apache.sling.validation.spi.support.DefaultValidationResult;
import org.osgi.service.component.annotations.Component;

@Component(property={"validator.id=org.apache.sling.validation.core.RegexValidator"})
public class RegexValidator
implements Validator<String> {
    @Nonnull
    public static final String I18N_KEY_PATTERN_DOES_NOT_MATCH = "sling.validator.regex.pattern-does-not-match";
    @Nonnull
    public static final String REGEX_PARAM = "regex";

    @Nonnull
    public ValidationResult validate(@Nonnull String data, @Nonnull ValidatorContext context, @Nonnull ValueMap arguments) throws SlingValidationException {
        String regex = (String)arguments.get(REGEX_PARAM, (Object)"");
        if (StringUtils.isEmpty((CharSequence)regex)) {
            throw new SlingValidationException("Mandatory argument 'regex' is missing from the arguments map.");
        }
        try {
            Pattern pattern = Pattern.compile(regex);
            if (pattern.matcher(data).matches()) {
                return DefaultValidationResult.VALID;
            }
            return new DefaultValidationResult(context, I18N_KEY_PATTERN_DOES_NOT_MATCH, new Object[]{regex});
        }
        catch (PatternSyntaxException e) {
            throw new SlingValidationException("Given pattern in argument 'regex' is invalid", (Throwable)e);
        }
    }
}

