/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import org.mockito.plugins.MockResolver;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SpringMockResolver
implements MockResolver {
    static final boolean springAopPresent = ClassUtils.isPresent((String)"org.springframework.aop.framework.Advised", (ClassLoader)SpringMockResolver.class.getClassLoader());

    public Object resolve(Object instance) {
        if (springAopPresent) {
            return SpringMockResolver.getUltimateTargetObject(instance);
        }
        return instance;
    }

    static Object getUltimateTargetObject(Object candidate) {
        Assert.notNull((Object)candidate, (String)"Candidate must not be null");
        try {
            Object target;
            Advised advised;
            TargetSource targetSource;
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised && (targetSource = (advised = (Advised)candidate).getTargetSource()).isStatic() && (target = targetSource.getTarget()) != null) {
                return SpringMockResolver.getUltimateTargetObject(target);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return candidate;
    }
}

