/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.resources.saml2sp4ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.resources.saml2sp4ui.AbstractSAML2SP4UIResource;
import org.apache.syncope.common.lib.saml2.SAML2LoginResponse;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.SAML2SP4UIService;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

public abstract class AssertionConsumerResource
extends AbstractSAML2SP4UIResource {
    private static final long serialVersionUID = 3858609271031003370L;
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).serializationInclusion(JsonInclude.Include.NON_EMPTY)).build();

    protected abstract Class<? extends WebPage> getLoginPageClass();

    protected abstract Pair<Class<? extends WebPage>, PageParameters> getSelfRegInfo(UserTO var1) throws JsonProcessingException;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        SAML2SP4UIService service = (SAML2SP4UIService)((BaseSession)BaseSession.class.cast(Session.get())).getAnonymousService(SAML2SP4UIService.class);
        SAML2LoginResponse response = service.validateLoginResponse(this.extract(attributes));
        if (response.isSelfReg()) {
            UserTO newUser = new UserTO();
            newUser.setUsername(response.getUsername());
            newUser.getPlainAttrs().addAll(response.getAttrs());
            try {
                Pair<Class<? extends WebPage>, PageParameters> selfRegInfo = this.getSelfRegInfo(newUser);
                throw new RestartResponseException((Class)selfRegInfo.getLeft(), (PageParameters)selfRegInfo.getRight());
            }
            catch (JsonProcessingException e) {
                LOG.error("Could not serialize new user {}", (Object)newUser, (Object)e);
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        throw new RestartResponseException(this.getLoginPageClass(), new PageParameters().set("saml2sp4ui.jwt", (Object)response.getAccessToken()).set("saml2sp4ui.jwt.expiration", (Object)response.getAccessTokenExpiryTime().toInstant()).set("saml2sp4ui.sloSupported", (Object)response.isSloSupported()));
    }
}

