/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.persistence.PostLoad;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultRegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyActivationCriteria;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.util.RegisteredServiceAccessStrategyEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DefaultRegisteredServiceAccessStrategy
extends BaseRegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServiceAccessStrategy.class);
    private static final long serialVersionUID = 1245279151345635245L;
    protected int order;
    protected boolean enabled = true;
    protected boolean ssoEnabled = true;
    protected URI unauthorizedRedirectUrl;
    protected boolean requireAllAttributes = true;
    protected Map<String, Set<String>> requiredAttributes = new HashMap<String, Set<String>>(0);
    protected Map<String, Set<String>> rejectedAttributes = new HashMap<String, Set<String>>(0);
    protected boolean caseInsensitive;
    protected RegisteredServiceAccessStrategyActivationCriteria activationCriteria;

    public DefaultRegisteredServiceAccessStrategy() {
        this(true, true);
    }

    public DefaultRegisteredServiceAccessStrategy(boolean enabled, boolean ssoEnabled) {
        this.enabled = enabled;
        this.ssoEnabled = ssoEnabled;
    }

    public DefaultRegisteredServiceAccessStrategy(Map<String, Set<String>> requiredAttributes, Map<String, Set<String>> rejectedAttributes) {
        this();
        this.requiredAttributes = (Map)ObjectUtils.defaultIfNull(requiredAttributes, new HashMap(0));
        this.rejectedAttributes = (Map)ObjectUtils.defaultIfNull(rejectedAttributes, new HashMap(0));
    }

    public DefaultRegisteredServiceAccessStrategy(Map<String, Set<String>> requiredAttributes) {
        this();
        this.requiredAttributes = (Map)ObjectUtils.defaultIfNull(requiredAttributes, new HashMap(0));
    }

    @PostLoad
    public void postLoad() {
        this.delegatedAuthenticationPolicy = (RegisteredServiceDelegatedAuthenticationPolicy)ObjectUtils.defaultIfNull((Object)this.delegatedAuthenticationPolicy, (Object)new DefaultRegisteredServiceDelegatedAuthenticationPolicy());
        this.requiredAttributes = (Map)ObjectUtils.defaultIfNull(this.requiredAttributes, new HashMap(0));
        this.rejectedAttributes = (Map)ObjectUtils.defaultIfNull(this.rejectedAttributes, new HashMap(0));
    }

    public boolean isServiceAccessAllowed(RegisteredService registeredService, Service service) {
        if (!this.enabled) {
            LOGGER.trace("Service is not enabled in service registry.");
            return false;
        }
        return true;
    }

    public boolean isServiceAccessAllowedForSso(RegisteredService registeredService) {
        if (!this.ssoEnabled) {
            LOGGER.trace("Service is not authorized to participate in SSO.");
            return false;
        }
        return true;
    }

    public boolean authorizeRequest(RegisteredServiceAccessStrategyRequest request) throws Throwable {
        boolean proceed;
        boolean bl = proceed = this.activationCriteria == null || this.activationCriteria.shouldActivate(request);
        if (proceed) {
            return ((RegisteredServiceAccessStrategyEvaluator)((RegisteredServiceAccessStrategyEvaluator.RegisteredServiceAccessStrategyEvaluatorBuilder)((RegisteredServiceAccessStrategyEvaluator.RegisteredServiceAccessStrategyEvaluatorBuilder)((RegisteredServiceAccessStrategyEvaluator.RegisteredServiceAccessStrategyEvaluatorBuilder)((RegisteredServiceAccessStrategyEvaluator.RegisteredServiceAccessStrategyEvaluatorBuilder)RegisteredServiceAccessStrategyEvaluator.builder().caseInsensitive(this.caseInsensitive)).requireAllAttributes(this.requireAllAttributes)).requiredAttributes(this.requiredAttributes)).rejectedAttributes(this.rejectedAttributes)).build()).apply(request);
        }
        return this.activationCriteria.isAllowIfInactive();
    }

    public Map<String, Set<String>> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @Override
    @Generated
    public String toString() {
        return "DefaultRegisteredServiceAccessStrategy(order=" + this.order + ", enabled=" + this.enabled + ", ssoEnabled=" + this.ssoEnabled + ", unauthorizedRedirectUrl=" + String.valueOf(this.unauthorizedRedirectUrl) + ", requireAllAttributes=" + this.requireAllAttributes + ", requiredAttributes=" + String.valueOf(this.requiredAttributes) + ", rejectedAttributes=" + String.valueOf(this.rejectedAttributes) + ", caseInsensitive=" + this.caseInsensitive + ", activationCriteria=" + String.valueOf(this.activationCriteria) + ")";
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    @Generated
    public URI getUnauthorizedRedirectUrl() {
        return this.unauthorizedRedirectUrl;
    }

    @Generated
    public boolean isRequireAllAttributes() {
        return this.requireAllAttributes;
    }

    @Generated
    public Map<String, Set<String>> getRejectedAttributes() {
        return this.rejectedAttributes;
    }

    @Generated
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Generated
    public RegisteredServiceAccessStrategyActivationCriteria getActivationCriteria() {
        return this.activationCriteria;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceAccessStrategy)) {
            return false;
        }
        DefaultRegisteredServiceAccessStrategy other = (DefaultRegisteredServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.ssoEnabled != other.ssoEnabled) {
            return false;
        }
        if (this.requireAllAttributes != other.requireAllAttributes) {
            return false;
        }
        if (this.caseInsensitive != other.caseInsensitive) {
            return false;
        }
        URI this$unauthorizedRedirectUrl = this.unauthorizedRedirectUrl;
        URI other$unauthorizedRedirectUrl = other.unauthorizedRedirectUrl;
        if (this$unauthorizedRedirectUrl == null ? other$unauthorizedRedirectUrl != null : !((Object)this$unauthorizedRedirectUrl).equals(other$unauthorizedRedirectUrl)) {
            return false;
        }
        Map<String, Set<String>> this$requiredAttributes = this.requiredAttributes;
        Map<String, Set<String>> other$requiredAttributes = other.requiredAttributes;
        if (this$requiredAttributes == null ? other$requiredAttributes != null : !((Object)this$requiredAttributes).equals(other$requiredAttributes)) {
            return false;
        }
        Map<String, Set<String>> this$rejectedAttributes = this.rejectedAttributes;
        Map<String, Set<String>> other$rejectedAttributes = other.rejectedAttributes;
        if (this$rejectedAttributes == null ? other$rejectedAttributes != null : !((Object)this$rejectedAttributes).equals(other$rejectedAttributes)) {
            return false;
        }
        RegisteredServiceAccessStrategyActivationCriteria this$activationCriteria = this.activationCriteria;
        RegisteredServiceAccessStrategyActivationCriteria other$activationCriteria = other.activationCriteria;
        return !(this$activationCriteria == null ? other$activationCriteria != null : !this$activationCriteria.equals(other$activationCriteria));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceAccessStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.order;
        result = result * 59 + (this.enabled ? 79 : 97);
        result = result * 59 + (this.ssoEnabled ? 79 : 97);
        result = result * 59 + (this.requireAllAttributes ? 79 : 97);
        result = result * 59 + (this.caseInsensitive ? 79 : 97);
        URI $unauthorizedRedirectUrl = this.unauthorizedRedirectUrl;
        result = result * 59 + ($unauthorizedRedirectUrl == null ? 43 : ((Object)$unauthorizedRedirectUrl).hashCode());
        Map<String, Set<String>> $requiredAttributes = this.requiredAttributes;
        result = result * 59 + ($requiredAttributes == null ? 43 : ((Object)$requiredAttributes).hashCode());
        Map<String, Set<String>> $rejectedAttributes = this.rejectedAttributes;
        result = result * 59 + ($rejectedAttributes == null ? 43 : ((Object)$rejectedAttributes).hashCode());
        RegisteredServiceAccessStrategyActivationCriteria $activationCriteria = this.activationCriteria;
        result = result * 59 + ($activationCriteria == null ? 43 : $activationCriteria.hashCode());
        return result;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setOrder(int order) {
        this.order = order;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setUnauthorizedRedirectUrl(URI unauthorizedRedirectUrl) {
        this.unauthorizedRedirectUrl = unauthorizedRedirectUrl;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setRequireAllAttributes(boolean requireAllAttributes) {
        this.requireAllAttributes = requireAllAttributes;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setRequiredAttributes(Map<String, Set<String>> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setRejectedAttributes(Map<String, Set<String>> rejectedAttributes) {
        this.rejectedAttributes = rejectedAttributes;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceAccessStrategy setActivationCriteria(RegisteredServiceAccessStrategyActivationCriteria activationCriteria) {
        this.activationCriteria = activationCriteria;
        return this;
    }
}

