/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.config.client.PropertiesConstants;
import org.pac4j.core.credentials.password.SpringSecurityPasswordEncoder;
import org.pac4j.core.exception.TechnicalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.password.StandardPasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;

public class SpringEncoderBuilder
extends AbstractBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringEncoderBuilder.class);

    public SpringEncoderBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreatePasswordEncoder(Map<String, org.pac4j.core.credentials.password.PasswordEncoder> encoders) {
        for (int i = 0; i <= 10; ++i) {
            PasswordEncoder encoder;
            String type = this.getProperty("encoder.spring.type", i);
            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
            if (PropertiesConstants.SpringEncoderType.NOOP.toString().equalsIgnoreCase(type)) {
                LOGGER.debug("Please notice that the NOOP Spring encoder type is insecure and for tests only");
                encoder = NoOpPasswordEncoder.getInstance();
            } else if (PropertiesConstants.SpringEncoderType.BCRYPT.toString().equalsIgnoreCase(type)) {
                encoder = this.containsProperty("encoder.spring.bcrypt.length", i) ? new BCryptPasswordEncoder(this.getPropertyAsInteger("encoder.spring.bcrypt.length", i)) : new BCryptPasswordEncoder();
            } else if (PropertiesConstants.SpringEncoderType.PBKDF2.toString().equalsIgnoreCase(type)) {
                if (this.containsProperty("encoder.spring.pbkdf2.secret", i)) {
                    String secret = this.getProperty("encoder.spring.pbkdf2.secret", i);
                    encoder = this.containsProperty("encoder.spring.pbkdf2.iterations", i) && this.containsProperty("encoder.spring.pbkdf2.hashWidth", i) ? new Pbkdf2PasswordEncoder((CharSequence)secret, 16, this.getPropertyAsInteger("encoder.spring.pbkdf2.iterations", i), this.getPropertyAsInteger("encoder.spring.pbkdf2.hashWidth", i)) : new Pbkdf2PasswordEncoder((CharSequence)secret, 16, 310000, Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA256);
                } else {
                    encoder = Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_8();
                }
            } else if (PropertiesConstants.SpringEncoderType.SCRYPT.toString().equalsIgnoreCase(type)) {
                encoder = this.containsProperty("encoder.spring.scrypt.cpuCost", i) && this.containsProperty("encoder.spring.scrypt.memoryCost", i) && this.containsProperty("encoder.spring.scrypt.parallelization", i) && this.containsProperty("encoder.spring.scrypt.keyLength", i) && this.containsProperty("encoder.spring.scrypt.saltLength", i) ? new SCryptPasswordEncoder(this.getPropertyAsInteger("encoder.spring.scrypt.cpuCost", i), this.getPropertyAsInteger("encoder.spring.scrypt.memoryCost", i), this.getPropertyAsInteger("encoder.spring.scrypt.parallelization", i), this.getPropertyAsInteger("encoder.spring.scrypt.keyLength", i), this.getPropertyAsInteger("encoder.spring.scrypt.saltLength", i)) : SCryptPasswordEncoder.defaultsForSpringSecurity_v5_8();
            } else if (PropertiesConstants.SpringEncoderType.STANDARD.toString().equalsIgnoreCase(type)) {
                LOGGER.debug("Please notice that the STANDARD Spring encoder type is insecure and for tests only");
                encoder = this.containsProperty("encoder.spring.standard.secret", i) ? new StandardPasswordEncoder((CharSequence)this.getProperty("encoder.spring.standard.secret", i)) : new StandardPasswordEncoder();
            } else {
                throw new TechnicalException("Unsupported spring encoder type: " + type);
            }
            encoders.put(this.concat("encoder.spring", i), (org.pac4j.core.credentials.password.PasswordEncoder)new SpringSecurityPasswordEncoder(encoder));
        }
    }
}

