/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public class SchemaValidateXMLMessage
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SchemaValidateXMLMessage.class);
    @Nonnull
    private final Schema validationSchema;

    public SchemaValidateXMLMessage(@Nonnull Schema schema) {
        this.validationSchema = (Schema)Constraint.isNotNull((Object)schema, (String)"Schema cannot be null");
    }

    @Nonnull
    public Schema getValidationSchema() {
        return this.validationSchema;
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        if (!(messageContext.getMessage() instanceof XMLObject)) {
            this.log.debug("{} Message context did not contain an XMLObject, unable to proceed", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Message context did not contain an XMLObject, unable to proceed.");
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("{} Attempting to schema validate incoming message", (Object)this.getLogPrefix());
        XMLObject message = (XMLObject)messageContext.ensureMessage();
        if (message.getDOM() == null) {
            this.log.debug("{} Message doesn't contain a DOM, unable to proceed", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Message doesn't contain a DOM, unable to proceed.");
        }
        try {
            Validator schemaValidator = this.validationSchema.newValidator();
            schemaValidator.validate(new DOMSource(message.getDOM()));
        }
        catch (SAXException e) {
            this.log.debug("{} Message {} is not schema-valid: {}", new Object[]{this.getLogPrefix(), message.getElementQName(), e.getMessage()});
            throw new MessageHandlerException("Message is not schema-valid.", (Exception)e);
        }
        catch (IOException e) {
            this.log.debug("{} Unable to read message: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException("Unable to read message.", (Exception)e);
        }
        this.log.debug("{} Message {} is valid", (Object)this.getLogPrefix(), (Object)message.getElementQName());
    }
}

