/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class ChildContextLookup<ParentContext extends BaseContext, ChildContext extends BaseContext>
implements ContextDataLookupFunction<ParentContext, ChildContext> {
    @Nonnull
    private final Class<ChildContext> childType;
    private boolean autocreate;

    public ChildContextLookup(@Nonnull @ParameterName(name="type") Class<ChildContext> type) {
        this.childType = (Class)Constraint.isNotNull(type, (String)"Child context type cannot be null");
        this.autocreate = false;
    }

    public ChildContextLookup(@Nonnull @ParameterName(name="type") Class<ChildContext> type, @ParameterName(name="createContext") boolean createContext) {
        this.childType = (Class)Constraint.isNotNull(type, (String)"Child context type cannot be null");
        this.autocreate = createContext;
    }

    @Override
    @Nullable
    public ChildContext apply(@Nullable ParentContext input) {
        if (input == null) {
            return null;
        }
        if (this.autocreate) {
            return ((BaseContext)input).ensureSubcontext(this.childType);
        }
        return ((BaseContext)input).getSubcontext(this.childType);
    }
}

