/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.engine.IdentityService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.GetPotentialStarterGroupsCmd;
import org.flowable.engine.impl.cmd.GetPotentialStarterUsersCmd;
import org.flowable.engine.impl.util.EngineServiceUtil;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.NativeGroupQuery;
import org.flowable.idm.api.NativeUserQuery;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;

public class IdentityServiceImpl
extends CommonEngineServiceImpl<ProcessEngineConfigurationImpl>
implements IdentityService {
    public IdentityServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super((AbstractEngineConfiguration)processEngineConfiguration);
    }

    @Override
    public Group newGroup(String groupId) {
        return this.getIdmIdentityService().newGroup(groupId);
    }

    @Override
    public User newUser(String userId) {
        return this.getIdmIdentityService().newUser(userId);
    }

    @Override
    public void saveGroup(Group group) {
        this.getIdmIdentityService().saveGroup(group);
    }

    @Override
    public void saveUser(User user) {
        this.getIdmIdentityService().saveUser(user);
    }

    @Override
    public void updateUserPassword(User user) {
        this.getIdmIdentityService().updateUserPassword(user);
    }

    @Override
    public UserQuery createUserQuery() {
        return this.getIdmIdentityService().createUserQuery();
    }

    @Override
    public NativeUserQuery createNativeUserQuery() {
        return this.getIdmIdentityService().createNativeUserQuery();
    }

    @Override
    public GroupQuery createGroupQuery() {
        return this.getIdmIdentityService().createGroupQuery();
    }

    @Override
    public NativeGroupQuery createNativeGroupQuery() {
        return this.getIdmIdentityService().createNativeGroupQuery();
    }

    @Override
    public List<Group> getPotentialStarterGroups(String processDefinitionId) {
        return (List)this.commandExecutor.execute((Command)new GetPotentialStarterGroupsCmd(processDefinitionId));
    }

    @Override
    public List<User> getPotentialStarterUsers(String processDefinitionId) {
        return (List)this.commandExecutor.execute((Command)new GetPotentialStarterUsersCmd(processDefinitionId));
    }

    @Override
    public void createMembership(String userId, String groupId) {
        this.getIdmIdentityService().createMembership(userId, groupId);
    }

    @Override
    public void deleteGroup(String groupId) {
        this.getIdmIdentityService().deleteGroup(groupId);
    }

    @Override
    public void deleteMembership(String userId, String groupId) {
        this.getIdmIdentityService().deleteMembership(userId, groupId);
    }

    @Override
    public boolean checkPassword(String userId, String password) {
        return this.getIdmIdentityService().checkPassword(userId, password);
    }

    @Override
    public void deleteUser(String userId) {
        this.getIdmIdentityService().deleteUser(userId);
    }

    @Override
    public void setUserPicture(String userId, Picture picture) {
        this.getIdmIdentityService().setUserPicture(userId, picture);
    }

    @Override
    public Picture getUserPicture(String userId) {
        return this.getIdmIdentityService().getUserPicture(userId);
    }

    @Override
    public void setAuthenticatedUserId(String authenticatedUserId) {
        Authentication.setAuthenticatedUserId((String)authenticatedUserId);
    }

    @Override
    public String getUserInfo(String userId, String key) {
        return this.getIdmIdentityService().getUserInfo(userId, key);
    }

    @Override
    public List<String> getUserInfoKeys(String userId) {
        return this.getIdmIdentityService().getUserInfoKeys(userId);
    }

    @Override
    public void setUserInfo(String userId, String key, String value) {
        this.getIdmIdentityService().setUserInfo(userId, key, value);
    }

    @Override
    public void deleteUserInfo(String userId, String key) {
        this.getIdmIdentityService().deleteUserInfo(userId, key);
    }

    protected IdmIdentityService getIdmIdentityService() {
        IdmIdentityService idmIdentityService = EngineServiceUtil.getIdmIdentityService((AbstractEngineConfiguration)this.configuration);
        if (idmIdentityService == null) {
            throw new FlowableException("Trying to use idm identity service when it is not initialized");
        }
        return idmIdentityService;
    }
}

