/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011%c\u0001\u00026l\u0001ADQa\u001e\u0001\u0005\u0002aD\u0011b\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001?\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003+\u0001\u0001\u0019!A!B\u0013i\b\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\r\u0011!\ty\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0019\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0005\u0001Q\u0001\n\u0005U\u0002\"CA'\u0001\t\u0007I\u0011AA(\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005E\u0003\"CA3\u0001\t\u0007I\u0011AA4\u0011!\t9\b\u0001Q\u0001\n\u0005%\u0004\u0002\u00037\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003wBq!a!\u0001\t\u0003\t)\tC\u0004\u0002\u001e\u0002!\t!!\"\u0007\r\u0005\u001d\u0006\u0001QAU\u0011)\tIm\u0005BK\u0002\u0013\u0005\u00111\u001a\u0005\u000b\u0003;\u001c\"\u0011#Q\u0001\n\u00055\u0007BCAp'\tU\r\u0011\"\u0001\u0002L\"Q\u0011\u0011]\n\u0003\u0012\u0003\u0006I!!4\t\r]\u001cB\u0011AAr\u0011\u001d\tio\u0005C\u0001\u0003_D\u0011B!\u0004\u0014#\u0003%\tAa\u0004\t\u0013\t\u00152#!A\u0005\u0002\t\u001d\u0002\"\u0003B\u0017'E\u0005I\u0011\u0001B\u0018\u0011%\u0011\u0019dEI\u0001\n\u0003\u0011y\u0003C\u0005\u00036M\t\t\u0011\"\u0011\u00038!I!1I\n\u0002\u0002\u0013\u0005!Q\t\u0005\n\u0005\u001b\u001a\u0012\u0011!C\u0001\u0005\u001fB\u0011B!\u0017\u0014\u0003\u0003%\tEa\u0017\t\u0013\t%4#!A\u0005\u0002\t-\u0004\"\u0003B;'\u0005\u0005I\u0011\tB<\u0011%\u0011YhEA\u0001\n\u0003\u0012i\bC\u0005\u0003\u0000M\t\t\u0011\"\u0011\u0003\u0002\"I!1Q\n\u0002\u0002\u0013\u0005#QQ\u0004\b\u0005\u0013\u0003\u0001\u0012\u0001BF\r\u001d\t9\u000b\u0001E\u0001\u0005\u001bCaa\u001e\u0015\u0005\u0002\tM\u0005b\u0002BKQ\u0011\u0005!q\u0013\u0005\n\u0005CC\u0013\u0011!CA\u0005GC\u0011B!+)\u0003\u0003%\tIa+\t\u000f\tu\u0006\u0001\"\u0003\u0003@\"9!Q\u001a\u0001\u0005\n\t=\u0007b\u0002Bl\u0001\u0011%!\u0011\u001c\u0005\n\u0005G\u0004\u0011\u0013!C\u0005\u0005KD\u0011B!;\u0001#\u0003%IAa\u0004\t\u000f\t-\b\u0001\"\u0003\u0003n\"I1Q\u0003\u0001\u0012\u0002\u0013%!Q\u001d\u0005\n\u0007/\u0001\u0011\u0013!C\u0005\u0005\u001fA\u0011b!\u0007\u0001#\u0003%Iaa\u0007\t\u0013\r}\u0001!%A\u0005\n\r\u0005\u0002\"CB\u0013\u0001E\u0005I\u0011BB\u0014\u0011%\u0019Y\u0003AI\u0001\n\u0013\u0019\t\u0003C\u0004\u0004.\u0001!\t!!\"\t\u000f\r]\u0002\u0001\"\u0001\u0002\u0006\"911\b\u0001\u0005\u0002\u0005\u0015\u0005bBB \u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007\u0007\u0002A\u0011AAC\u0011\u001d\u00199\u0005\u0001C\u0001\u0003\u000bCqaa\u0013\u0001\t\u0003\t)\tC\u0004\u0004P\u0001!\t!!\"\t\u000f\rM\u0003\u0001\"\u0001\u0002\u0006\"91q\u000b\u0001\u0005\u0002\u0005\u0015\u0005bBB.\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007?\u0002A\u0011AAC\u0011\u001d\u0019\u0019\u0007\u0001C\u0001\u0003\u000bCqaa\u001a\u0001\t\u0013\u0019I\u0007C\u0004\u0004p\u0001!\t!!\"\t\u000f\rM\u0004\u0001\"\u0001\u0002\u0006\"91q\u000f\u0001\u0005\n\re\u0004bBB?\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007\u0003\u0003A\u0011AAC\u0011\u001d\u0019)\t\u0001C\u0001\u0003\u000bCqa!#\u0001\t\u0003\t)\tC\u0004\u0004\u000e\u0002!\t!!\"\t\u000f\rE\u0005\u0001\"\u0001\u0002\u0006\"91Q\u0013\u0001\u0005\u0002\u0005\u0015\u0005bBBM\u0001\u0011%11\u0014\u0005\b\u0007K\u0003A\u0011AAC\u0011\u001d\u0019I\u000b\u0001C\u0001\u0003\u000bCqa!,\u0001\t\u0003\t)\tC\u0004\u00042\u0002!\t!!\"\t\u000f\rU\u0006\u0001\"\u0001\u0002\u0006\"91\u0011\u0018\u0001\u0005\u0002\u0005\u0015\u0005bBB_\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007\u0003\u0004A\u0011AAC\u0011\u001d\u0019)\r\u0001C\u0001\u0003\u000bCqa!3\u0001\t\u0003\t)\tC\u0004\u0004N\u0002!\t!!\"\t\u000f\rE\u0007\u0001\"\u0001\u0002\u0006\"91Q\u001b\u0001\u0005\u0002\u0005\u0015\u0005bBBm\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007;\u0004A\u0011AAC\u0011\u001d\u0019\t\u000f\u0001C\u0005\u0007GD\u0011\u0002\"\t\u0001#\u0003%I\u0001b\t\t\u0013\u0011\u001d\u0002!%A\u0005\n\u0011%\u0002\"\u0003C\u0017\u0001E\u0005I\u0011\u0002B\b\u0011%!y\u0003AI\u0001\n\u0013\u00199\u0003C\u0005\u00052\u0001\t\n\u0011\"\u0003\u00054!IAq\u0007\u0001\u0012\u0002\u0013%A\u0011\b\u0005\n\t{\u0001\u0011\u0013!C\u0005\t\u007fA\u0011\u0002b\u0011\u0001#\u0003%I\u0001\"\u0012\u0003\u00191{7-\u00197M_\u001e$Vm\u001d;\u000b\u00051l\u0017a\u00017pO*\ta.A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\bC\u0001:v\u001b\u0005\u0019(\"\u0001;\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001c(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002sB\u0011!\u0010A\u0007\u0002W\u000611m\u001c8gS\u001e,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q.\u0001\u0004tKJ4XM]\u0005\u0004\u0003\u000by(aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\u0011\tY!!\u0005\u0011\u0007I\fi!C\u0002\u0002\u0010M\u0014A!\u00168ji\"A\u00111C\u0002\u0002\u0002\u0003\u0007Q0A\u0002yIE\nqaY8oM&<\u0007%\u0001\u0004u[B$\u0015N]\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0002j_*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!!\u000e\u0011\t\u0005]\u0012qI\u0007\u0003\u0003sQA!a\u000f\u0002>\u000511m\\7n_:T1A\\A \u0015\u0011\t\t%a\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)%A\u0002pe\u001eLA!!\u0013\u0002:\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\t\t\u0006\u0005\u0003\u0002T\u0005}SBAA+\u0015\ra\u0017q\u000b\u0006\u0005\u00033\nY&A\u0005j]R,'O\\1mg*!\u0011QLA\u001f\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0019\u0002V\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0005n_\u000e\\G+[7f+\t\tI\u0007\u0005\u0003\u0002l\u0005MTBAA7\u0015\u0011\ty'!\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0005\u0003\u0003\ti$\u0003\u0003\u0002v\u00055$\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004SCAA>!\rQ\u0018QP\u0005\u0004\u0003\u007fZ'\u0001\u0003'pG\u0006dGj\\4\u0002\t1|w\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003\u0017A3!EAE!\u0011\tY)!'\u000e\u0005\u00055%\u0002BAH\u0003#\u000b1!\u00199j\u0015\u0011\t\u0019*!&\u0002\u000f),\b/\u001b;fe*!\u0011qSA\"\u0003\u0015QWO\\5u\u0013\u0011\tY*!$\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0011\u0012\u0011\u0015\t\u0005\u0003\u0017\u000b\u0019+\u0003\u0003\u0002&\u00065%!C!gi\u0016\u0014X)Y2i\u0005!YU-\u001f,bYV,7CB\nr\u0003W\u000b\t\fE\u0002s\u0003[K1!a,t\u0005\u001d\u0001&o\u001c3vGR\u0004B!a-\u0002D:!\u0011QWA`\u001d\u0011\t9,!0\u000e\u0005\u0005e&bAA^_\u00061AH]8pizJ\u0011\u0001^\u0005\u0004\u0003\u0003\u001c\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\f9M\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002BN\f1a[3z+\t\ti\r\u0005\u0003\u0002P\u0006]g\u0002BAi\u0003'\u00042!a.t\u0013\r\t)n]\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00171\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U7/\u0001\u0003lKf\u0004\u0013!\u0002<bYV,\u0017A\u0002<bYV,\u0007\u0005\u0006\u0004\u0002f\u0006%\u00181\u001e\t\u0004\u0003O\u001cR\"\u0001\u0001\t\u000f\u0005%\u0007\u00041\u0001\u0002N\"9\u0011q\u001c\rA\u0002\u00055\u0017\u0001\u0003;p%\u0016\u001cwN\u001d3\u0015\t\u0005E\u0018Q \t\u0005\u0003g\fI0\u0004\u0002\u0002v*!\u0011q_A\u001d\u0003\u0019\u0011XmY8sI&!\u00111`A{\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0011%\ty0\u0007I\u0005\u0002\u0004\u0011\t!A\u0005uS6,7\u000f^1naB)!Oa\u0001\u0003\b%\u0019!QA:\u0003\u0011q\u0012\u0017P\\1nKz\u00022A\u001dB\u0005\u0013\r\u0011Ya\u001d\u0002\u0005\u0019>tw-\u0001\nu_J+7m\u001c:eI\u0011,g-Y;mi\u0012\nTC\u0001B\tU\u0011\u00119Aa\u0005,\u0005\tU\u0001\u0003\u0002B\f\u0005Ci!A!\u0007\u000b\t\tm!QD\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\bt\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005G\u0011IBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAaY8qsR1\u0011Q\u001dB\u0015\u0005WA\u0011\"!3\u001c!\u0003\u0005\r!!4\t\u0013\u0005}7\u0004%AA\u0002\u00055\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005cQC!!4\u0003\u0014\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003:A!!1\bB!\u001b\t\u0011iD\u0003\u0003\u0003@\u0005\r\u0012\u0001\u00027b]\u001eLA!!7\u0003>\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\t\t\u0004e\n%\u0013b\u0001B&g\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u000bB,!\r\u0011(1K\u0005\u0004\u0005+\u001a(aA!os\"I\u00111\u0003\u0011\u0002\u0002\u0003\u0007!qI\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\f\t\u0007\u0005?\u0012)G!\u0015\u000e\u0005\t\u0005$b\u0001B2g\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u001d$\u0011\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003n\tM\u0004c\u0001:\u0003p%\u0019!\u0011O:\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u0003\u0012\u0002\u0002\u0003\u0007!\u0011K\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003:\te\u0004\"CA\nG\u0005\u0005\t\u0019\u0001B$\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B$\u0003!!xn\u0015;sS:<GC\u0001B\u001d\u0003\u0019)\u0017/^1mgR!!Q\u000eBD\u0011%\t\u0019BJA\u0001\u0002\u0004\u0011\t&\u0001\u0005LKf4\u0016\r\\;f!\r\t9\u000fK\n\u0005QE\u0014y\t\u0005\u0003\u0002\u001e\tE\u0015\u0002BAc\u0003?!\"Aa#\u0002\u0015\u0019\u0014x.\u001c*fG>\u0014H\r\u0006\u0003\u0002f\ne\u0005bBA|U\u0001\u0007!1\u0014\t\u0005\u0003g\u0014i*\u0003\u0003\u0003 \u0006U(A\u0002*fG>\u0014H-A\u0003baBd\u0017\u0010\u0006\u0004\u0002f\n\u0015&q\u0015\u0005\b\u0003\u0013\\\u0003\u0019AAg\u0011\u001d\tyn\u000ba\u0001\u0003\u001b\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003.\ne\u0006#\u0002:\u00030\nM\u0016b\u0001BYg\n1q\n\u001d;j_:\u0004rA\u001dB[\u0003\u001b\fi-C\u0002\u00038N\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003B^Y\u0005\u0005\t\u0019AAs\u0003\rAH\u0005M\u0001\rWZ\u001cHk\u001c*fG>\u0014Hm\u001d\u000b\u0005\u0005\u0003\u00149\r\u0005\u0004\u00024\n\r\u0017\u0011_\u0005\u0005\u0005\u000b\f9M\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011I-\fa\u0001\u0005\u0017\f\u0011b[3z-\u0006dW/Z:\u0011\r\u0005M&1YAs\u00031\u0011XmY8sIN$vn\u0013<t)\u0011\u0011YM!5\t\u000f\tMg\u00061\u0001\u0003V\u00069!/Z2pe\u0012\u001c\bCBAZ\u0005\u0007\u0014Y*A\u0007baB,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\t\u0003\u0017\u0011YN!8\u0003`\"9!1[\u0018A\u0002\t\u0005\u0007\u0002\u000370!\u0003\u0005\r!a\u001f\t\u0013\t\u0005x\u0006%AA\u0002\t\u001d\u0011!D5oSRL\u0017\r\\(gMN,G/A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u001d\u0016\u0005\u0003w\u0012\u0019\"A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cwN\u001d3t)9\u0011yO!>\u0003x\nm8\u0011AB\u0003\u0007#\u0001B!a\u0015\u0003r&!!1_A+\u000551U\r^2i\t\u0006$\u0018-\u00138g_\"AAN\rI\u0001\u0002\u0004\tY\bC\u0005\u0003zJ\u0002\n\u00111\u0001\u0003\b\u0005Y1\u000f^1si>3gm]3u\u0011%\u0011iP\rI\u0005\u0002\u0004\u0011y0A\u0005nCbdUM\\4uQB)!Oa\u0001\u0003H!I11\u0001\u001a\u0011\u0002\u0003\u0007!QN\u0001\u000e[&twJ\\3NKN\u001c\u0018mZ3\t\u0013\r\u001d!\u0007%CA\u0002\r%\u0011!E7bq>3gm]3u\u001b\u0016$\u0018\rZ1uCB)!Oa\u0001\u0004\fA!\u00111KB\u0007\u0013\u0011\u0019y!!\u0016\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rC\u0005\u0004\u0014I\u0002\n\u00111\u0001\u0003n\u0005\u0011\u0012N\\2mk\u0012,\u0017IY8si\u0016$G\u000b\u001f8t\u0003U\u0011X-\u00193SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIE\nQC]3bIJ+7m\u001c:eg\u0012\"WMZ1vYR$#'A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\ru!\u0006\u0002B$\u0005'\tQC]3bIJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0004$)\"!Q\u000eB\n\u0003U\u0011X-\u00193SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIU*\"a!\u000b+\t\r-!1C\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003q!Xm\u001d;M_\u001e$U\r\\3uKN+w-\\3oiN\u001cVoY2fgND3!OB\u0019!\u0011\tYia\r\n\t\rU\u0012Q\u0012\u0002\u0005)\u0016\u001cH/\u0001\u000euKN$(k\u001c7m\u000b6\u0004H/_!di&4XmU3h[\u0016tG\u000fK\u0002;\u0007c\ta\u0007^3ti2{w\rR3mKR,G)\u001b:Tk\u000e\u001cWm]:XQ\u0016tW)\u001c9us\u0006sGMR1jYV\u0014Xm\u00165f]:{g.R7qifD3aOB\u0019\u0003A!Xm\u001d;Va\u0012\fG/Z\"p]\u001aLw\rK\u0002=\u0007c\t\u0001\u0004^3ti2{w\rR5s%\u0016t\u0017-\\3U_:+w\u000fR5sQ\ri4\u0011G\u0001\u001ei\u0016\u001cH\u000fT8h\t&\u0014(+\u001a8b[\u0016$v.\u0012=jgRLgn\u001a#je\"\u001aah!\r\u0002\u0019Q,7\u000f\u001e'pO\u001acWo\u001d5)\u0007}\u001a\t$A\u0007uKN$Hj\\4BaB,g\u000e\u001a\u0015\u0004\u0001\u000eE\u0012a\u0005;fgRdunZ\"m_N,7+^2dKN\u001c\bfA!\u00042\u00051B/Z:u\u0019><7\t\\8tK&#W-\u001c9pi\u0016tG\u000fK\u0002C\u0007c\t1\u0006^3ti2{wm\u00117pg\u00164\u0015-\u001b7ve\u0016<\u0006.\u001a8J]6+Wn\u001c:z\u0005V4g-\u001a:DY>\u001cX\r\u001a\u0015\u0004\u0007\u000eE\u0012\u0001\u0006;fgRdunZ\"m_N,\u0007*\u00198eY\u0016\u00148\u000fK\u0002E\u0007c\ta\u0004^3ti2{wm\u00117pg\u0016D\u0015M\u001c3mKJ\u001c\u0018\nZ3na>$XM\u001c;)\u0007\u0015\u001b\t$A\u000euKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo\u001d\u000b\u0005\u0003\u0017\u0019Y\u0007C\u0004\u0004n\u0019\u0003\rA!\u001c\u0002\u0017\u0005\u001c\u0018P\\2EK2,G/Z\u0001 i\u0016\u001cHOU3n_Z,\u0017I\u001c3EK2,G/Z*fO6,g\u000e^:Ts:\u001c\u0007fA$\u00042\u0005\u0001C/Z:u%\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN\f5/\u001f8dQ\rA5\u0011G\u0001\u0017i\u0016\u001cH\u000fR3mKR,7+Z4nK:$h)\u001b7fgR!\u00111BB>\u0011\u001d\u0019i'\u0013a\u0001\u0005[\n!\u0004^3ti\u0012+G.\u001a;f'\u0016<W.\u001a8u\r&dWm]*z]\u000eD3ASB\u0019\u0003m!Xm\u001d;EK2,G/Z*fO6,g\u000e\u001e$jY\u0016\u001c\u0018i]=oG\"\u001a1j!\r\u00025Q,7\u000f^\"sK\u0006$X-\u00118e\t\u0016dW\r^3TK\u001elWM\u001c;)\u00071\u001b\t$A\u000euKN$HK];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u0015\u0004\u001b\u000eE\u0012A\n;fgR<\u0006.\u001a8GKR\u001c\u0007n\u00144gg\u0016$\b*[4iKJ$\u0006.\u00198NCb|eMZ:fi\"\u001aaj!\r\u0002\u001dQ,7\u000f\u001e+sk:\u001c\u0017\r^3U_\"\u001aqj!\r\u00023Q,7\u000f\u001e(p]\u0006\u001bG/\u001b<f'\u0016<W.\u001a8ug\u001a\u0013x.\u001c\u0015\u0004!\u000eE\u0012A\u0005;pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u0016$b!!4\u0004\u001e\u000e\u0005\u0006bBBP#\u0002\u0007\u0011QZ\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0007G\u000b\u0006\u0019AAg\u0003%\u0001\u0018M\u001d;ji&|g.A\u000euKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a\u0015\u0004%\u000eE\u0012\u0001\u000e;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWmV5uQB+'/[8e\r>\u0014H)\u001a7fi\u0016$Gk\u001c9jG\"\u001a1k!\r\u0002OQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X)\u001c9us:\u000bW.\u001a\u0015\u0004)\u000eE\u0012A\t;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u001dVdG\u000eK\u0002V\u0007c\ta\u0006^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:NSN\u001c\u0018N\\4TKB\f'/\u0019;pe\"\u001aak!\r\u0002UQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X*[:tS:<Gk\u001c9jG\"\u001aqk!\r\u0002]Q,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X*[:tS:<\u0007+\u0019:uSRLwN\u001c\u0015\u00041\u000eE\u0012A\f;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u0013:4\u0018\r\\5e!\u0006\u0014H/\u001b;j_:D3!WB\u0019\u0003A\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/\u0012=jgRLgnZ%om\u0006d\u0017\u000e\u001a#je\"\u001a!l!\r\u0002)Q,7\u000f\u001e'pO\u0012+G.\u001a;f\t&\u0014h*Y7fQ\rY6\u0011G\u0001\u0013i\u0016\u001cHo\u00144gg\u0016$hI]8n\r&dW\rK\u0002]\u0007c\t\u0001\u0005^3tiJ{G\u000e\\*fO6,g\u000e\u001e+iCR\fEN]3bIf,\u00050[:ug\"\u001aQl!\r\u00021Q,7\u000f\u001e(foN+w-\\3oiN\fe\r^3s%>dG\u000eK\u0002_\u0007c\t1\u0006^3tiJ{G\u000e\\*fO6,g\u000e^#se>\u0014x\u000b[3o\u001d\u0016DHo\u00144gg\u0016$\u0018j]%mY\u0016<\u0017\r\u001c\u0015\u0004?\u000eE\u0012A\u0007;fgR4E.^:iS:<gj\u001c8Fq&\u001cH/\u001a8u\t&\u0014\bf\u00011\u00042\u0005y2M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;\u0015)\u0005m4Q]Bu\u0007c\u001cYpa@\u0005\u0004\u00115AQ\u0004C\u0010\u0011%\u00199/\u0019I\u0001\u0002\u0004\tY\"A\u0002eSJDaa_1A\u0002\r-\b\u0003BA*\u0007[LAaa<\u0002V\tIAj\\4D_:4\u0017n\u001a\u0005\n\u0007g\f\u0007\u0013!a\u0001\u0007k\f\u0001b]3h[\u0016tGo\u001d\t\u0005\u0003'\u001a90\u0003\u0003\u0004z\u0006U#a\u0003'pON+w-\\3oiND\u0011b!@b!\u0003\u0005\rAa\u0002\u0002\u001bI,7m\u001c<fef\u0004v.\u001b8u\u0011%!\t!\u0019I\u0001\u0002\u0004\u0019Y!\u0001\noKb$xJ\u001a4tKRlU\r^1eCR\f\u0007\"\u0003C\u0003CB\u0005\t\u0019\u0001C\u0004\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002l\u0011%\u0011\u0002\u0002C\u0006\u0003[\u0012\u0011bU2iK\u0012,H.\u001a:\t\u0013\u0011=\u0011\r%AA\u0002\u0011E\u0011\u0001\u0002;j[\u0016\u0004B\u0001b\u0005\u0005\u001a5\u0011AQ\u0003\u0006\u0005\t/\tI$A\u0003vi&d7/\u0003\u0003\u0005\u001c\u0011U!\u0001\u0002+j[\u0016D\u0011\"!\rb!\u0003\u0005\r!!\u000e\t\u0013\u00055\u0013\r%AA\u0002\u0005E\u0013!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0005&)\"\u00111\u0004B\n\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011A1\u0006\u0016\u0005\u0007k\u0014\u0019\"A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001b\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t!)D\u000b\u0003\u0005\b\tM\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$s'\u0006\u0002\u0005<)\"A\u0011\u0003B\n\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%qU\u0011A\u0011\t\u0016\u0005\u0003k\u0011\u0019\"A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%O\u000b\u0003\t\u000fRC!!\u0015\u0003\u0014\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var20_8 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var21_11 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var22_14 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", x$4, x$5, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> kv.toRecord$default$1()));
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable)r -> this.KeyValue().fromRecord((Record)r));
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        boolean bl = false;
        NoCompression withRecords_compression = Compression.NONE;
        Object var5_6 = null;
        simpleRecordArray = null;
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Vector segmentsBeforeDelete = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values()).asScala().toVector();
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = oldConfig.segmentSize + 1;
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().forEach(segment -> Assertions.assertEquals((Object)newLogDir.getPath(), (Object)segment.log().file().getParentFile().getPath()));
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        LocalLog x$2 = this.log();
        long x$3 = 0L;
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfoBeforeAppend = x$2.read(x$3, 1, x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfoBeforeAppend.records.records()).asScala().isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var9_10 = null;
        FetchDataInfo fetchDataInfo = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala()));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete)));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        Vector toDelete = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values()).asScala().toVector();
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Vector toDelete = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values()).asScala().toVector();
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.log();
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.log();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Vector expected = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values()).asScala().toVector();
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        LocalLog x$8 = this.log();
        boolean x$10 = false;
        boolean x$12 = false;
        long readRecords_startOffset = 10L;
        FetchDataInfo fetchDataInfo = x$8.read(readRecords_startOffset, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
    }

    @Test
    public void testWhenFetchOffsetHigherThanMaxOffset() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        LocalLog x$6 = this.log();
        boolean x$8 = false;
        boolean x$9 = false;
        long readRecords_startOffset = 3L;
        FetchDataInfo fetchDataInfo = x$6.read(readRecords_startOffset, this.readRecords$default$3(), x$8, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$2(), x$9);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)new LogOffsetMetadata(3L, 2L, 69), (Object)fetchDataInfo.fetchOffsetMetadata);
        LocalLog x$12 = this.log();
        boolean x$14 = false;
        boolean x$15 = false;
        long readRecords_startOffset2 = 4L;
        fetchDataInfo = x$12.read(readRecords_startOffset2, this.readRecords$default$3(), x$14, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$4(), x$15);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
        Assertions.assertEquals((Object)new LogOffsetMetadata(4L, 4L, 0), (Object)fetchDataInfo.fetchOffsetMetadata);
        LocalLog x$18 = this.log();
        boolean x$20 = false;
        boolean x$21 = false;
        long readRecords_startOffset3 = 5L;
        fetchDataInfo = x$18.read(readRecords_startOffset3, this.readRecords$default$3(), x$20, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$6(), x$21);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
        Assertions.assertEquals((Object)new LogOffsetMetadata(5L, 4L, 69), (Object)fetchDataInfo.fetchOffsetMetadata);
        LocalLog x$24 = this.log();
        boolean x$26 = false;
        boolean x$27 = false;
        long readRecords_startOffset4 = 3L;
        fetchDataInfo = x$24.read(readRecords_startOffset4, this.readRecords$default$3(), x$26, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$8(), x$27);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
        Assertions.assertEquals((Object)new LogOffsetMetadata(3L, 2L, 69), (Object)fetchDataInfo.fetchOffsetMetadata);
        LocalLog x$30 = this.log();
        boolean x$32 = false;
        boolean x$33 = false;
        long readRecords_startOffset5 = 3L;
        fetchDataInfo = x$30.read(readRecords_startOffset5, this.readRecords$default$3(), x$32, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$10(), x$33);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
        Assertions.assertEquals((Object)new LogOffsetMetadata(3L, 2L, 69), (Object)fetchDataInfo.fetchOffsetMetadata);
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        Vector expected = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values(9L, this.log().logEndOffset() + 1L)).asScala().toVector();
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted.toVector());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        LocalLog x$5 = this.log();
        boolean x$7 = false;
        boolean x$9 = false;
        long readRecords_startOffset = 6L;
        FetchDataInfo fetchDataInfo = x$5.read(readRecords_startOffset, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala()));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        LocalLog x$12 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, 7L);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile_dir = this.tmpDir();
        Object var6_2 = null;
        File logFile = LogFileUtils.logFile((File)logFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)logFile));
        File offsetIndexFile_dir = this.tmpDir();
        Object var7_4 = null;
        File offsetIndexFile = LogFileUtils.offsetIndexFile((File)offsetIndexFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)offsetIndexFile));
        File timeIndexFile_dir = this.tmpDir();
        Object var8_6 = null;
        File timeIndexFile = LogFileUtils.timeIndexFile((File)timeIndexFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        List x$1 = keyValues2.map((Function1 & Serializable)x$3 -> x$3.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.mockTime().milliseconds() + 10L));
        LocalLog x$32 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$32, 1L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var6_8 = null;
        FetchDataInfo readResult = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records.records()).asScala().size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((IterableOnce)keyValues2), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records.records()).asScala()));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable x$1 = (JFunction0.mcJ.sp & Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.log(), 0L);
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable x$2 = (JFunction0.mcJ.sp & Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        LocalLog x$5 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, 1L);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    @Test
    public void testFlushingNonExistentDir() {
        LocalLog spyLog = (LocalLog)Mockito.spy((Object)this.log());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        ((LocalLog)Mockito.doReturn((Object)new File("__NON_EXISTENT__"), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLog)).dir();
        Assertions.assertDoesNotThrow(() -> spyLog.flush(newSegment.baseOffset()));
    }

    /*
     * WARNING - void declaration
     */
    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        void open_preallocate;
        void open_initFileSize;
        boolean bl = config.preallocate;
        int n = config.initFileSize();
        long open_baseOffset = 0L;
        segments.add(LogSegment.open((File)dir, (long)open_baseOffset, (LogConfig)config, (Time)time, (boolean)false, (int)open_initFileSize, (boolean)open_preallocate, (String)""));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler;
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testWhenFetchOffsetHigherThanMaxOffset$1(LocalLogTest $this, SimpleRecord record$2, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$2, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$2() {
        return new LogOffsetMetadata(4L, 4L, 0);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$4() {
        return new LogOffsetMetadata(4L, 4L, 0);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$6() {
        return new LogOffsetMetadata(4L, 4L, 0);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$8() {
        return new LogOffsetMetadata(4L, -1L, -1);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$10() {
        return new LogOffsetMetadata(4L, 0L, 40);
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().nonActiveLogSegmentsFrom(startOffset)).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.baseOffset()))).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(604800000L, 0x40000000, 604800000L, -2L, -1L, -2L, 0L, "delete", 0x10000C, 4096, 0xA00000, 60000L, false);
        File x$2 = this.logDir();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = 0L;
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        MockTime x$7 = this.mockTime();
        TopicPartition x$8 = this.topicPartition();
        LogDirFailureChannel x$9 = this.logDirFailureChannel();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, (Time)x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof KeyValue && ((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() == this.kafka$log$LocalLogTest$KeyValue$$$outer())) break block3;
                    KeyValue keyValue = (KeyValue)x$1;
                    String string = this.key();
                    String string2 = keyValue.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = keyValue.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !keyValue.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

