/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.config.InitFacesContext;
import com.sun.faces.el.ELUtils;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.FunctionMapper;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ELContextImpl
extends ELContext {
    private FunctionMapper functionMapper = new NoopFunctionMapper();
    private VariableMapper variableMapper;
    private ELResolver resolver;

    public ELContextImpl(ELResolver resolver) {
        this.resolver = resolver;
    }

    public ELContextImpl(FacesContext facesContext) {
        this(facesContext.getApplication().getELResolver());
        UIViewRoot root;
        this.putContext(FacesContext.class, facesContext);
        ExpressionFactory expressionFactory = ELUtils.getDefaultExpressionFactory(facesContext);
        if (expressionFactory != null) {
            this.putContext(ExpressionFactory.class, expressionFactory);
        }
        if (!(facesContext instanceof InitFacesContext) && (root = facesContext.getViewRoot()) != null) {
            this.setLocale(root.getLocale());
        }
    }

    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    public VariableMapper getVariableMapper() {
        if (this.variableMapper == null) {
            this.variableMapper = new VariableMapperImpl();
        }
        return this.variableMapper;
    }

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public void setFunctionMapper(FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }

    private static class NoopFunctionMapper
    extends FunctionMapper {
        private NoopFunctionMapper() {
        }

        public Method resolveFunction(String s, String s1) {
            return null;
        }
    }

    private static class VariableMapperImpl
    extends VariableMapper {
        private Map<String, ValueExpression> variables = new HashMap<String, ValueExpression>();

        public ValueExpression resolveVariable(String variable) {
            return this.variables.get(variable);
        }

        public ValueExpression setVariable(String variable, ValueExpression valueExpression) {
            return this.variables.put(variable, valueExpression);
        }
    }
}

