/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.asn1;

import io.churchkey.shade.util.Hex;
import io.churchkey.shade.util.Join;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Oid {
    final List<Integer> oid = new ArrayList<Integer>();

    public Oid(int ... oid) {
        for (int i : oid) {
            this.oid.add(i);
        }
    }

    public Oid(List<Integer> oid) {
        this.oid.addAll(oid);
    }

    public int length() {
        return this.oid.size();
    }

    public int get(int index) {
        return this.oid.get(index);
    }

    public List<Integer> getComponents() {
        return Collections.unmodifiableList(this.oid);
    }

    public String toString() {
        return Join.join(".", this.oid);
    }

    public String toHex() {
        return Hex.toString(this.toBytes());
    }

    public byte[] toBytes() {
        Iterator<Integer> values = this.oid.iterator();
        Integer one = values.next();
        Integer two = values.next();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int val1 = one * 40 + two;
        out.write(val1);
        while (values.hasNext()) {
            int elem = values.next();
            if (elem <= 127) {
                out.write(elem);
                continue;
            }
            byte[] bytes = new byte[5];
            int pos = bytes.length - 1;
            bytes[pos--] = (byte)(elem & 0x7F);
            elem >>= 7;
            while (elem > 0) {
                bytes[pos--] = (byte)(elem | 0x80);
                elem >>= 7;
            }
            int length = bytes.length - ++pos;
            out.write(bytes, pos, length);
        }
        return out.toByteArray();
    }

    public static Oid fromString(String dottedIntegers) {
        String[] strings = dottedIntegers.split("\\.");
        List<Integer> integers = Stream.of(strings).map(Integer::valueOf).collect(Collectors.toList());
        return new Oid(integers);
    }

    public static Oid fromHex(String hex) throws IOException {
        byte[] bytes = Hex.fromString(hex);
        return Oid.fromBytes(bytes);
    }

    public static Oid oid(int ... oid) {
        return new Oid(oid);
    }

    public static Oid fromBytes(byte[] bytes) throws IOException {
        int length = bytes.length;
        if (length <= 0) {
            throw new EOFException("Not enough data for an OID");
        }
        int toPositiveNumber = 255;
        int shortForm = 127;
        ArrayList<Integer> oid = new ArrayList<Integer>(length + 1);
        int firstValue = bytes[0] & 0xFF;
        oid.add(firstValue / 40);
        oid.add(firstValue % 40);
        for (int position = 1; position < length; ++position) {
            int b = bytes[position] & 0xFF;
            if (b <= 127) {
                oid.add(b);
                continue;
            }
            long value = b & 0x7F;
            ++position;
            int subLen = 1;
            while (true) {
                if (position >= length) {
                    throw new EOFException("Incomplete OID value");
                }
                if (subLen > 5) {
                    throw new StreamCorruptedException("OID component encoding beyond 5 bytes");
                }
                b = bytes[position] & 0xFF;
                if ((value = value << 7 & 0xFFFFFFFF80L | (long)b & 0x7FL) > Integer.MAX_VALUE) {
                    throw new StreamCorruptedException("OID value exceeds 32 bits: " + value);
                }
                if (b <= 127) break;
                ++subLen;
                ++position;
            }
            oid.add((int)(value & Integer.MAX_VALUE));
        }
        return new Oid(oid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Oid oid1 = (Oid)o;
        return this.oid.equals(oid1.oid);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }
}

