/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.connectionmanagerconfig;

import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.SinglePoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.SinglePoolMatchAllConnectionInterceptor;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;

public class SinglePool
implements PoolingSupport {
    private static final long serialVersionUID = -1190636112655036636L;
    private int maxSize;
    private int minSize;
    private int blockingTimeoutMilliseconds;
    private int idleTimeoutMinutes;
    private boolean matchOne;
    private boolean matchAll;
    private boolean selectOneAssumeMatch;
    private transient PoolingAttributes pool;

    public SinglePool(int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes, boolean matchOne, boolean matchAll, boolean selectOneAssumeMatch) {
        this.maxSize = maxSize;
        this.minSize = minSize;
        this.blockingTimeoutMilliseconds = blockingTimeoutMilliseconds;
        this.idleTimeoutMinutes = idleTimeoutMinutes;
        this.matchOne = matchOne;
        this.matchAll = matchAll;
        this.selectOneAssumeMatch = selectOneAssumeMatch;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public int getBlockingTimeoutMilliseconds() {
        return this.blockingTimeoutMilliseconds;
    }

    @Override
    public void setBlockingTimeoutMilliseconds(int blockingTimeoutMilliseconds) {
        this.blockingTimeoutMilliseconds = blockingTimeoutMilliseconds;
        if (this.pool != null) {
            this.pool.setBlockingTimeoutMilliseconds(blockingTimeoutMilliseconds);
        }
    }

    @Override
    public int getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    @Override
    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.idleTimeoutMinutes = idleTimeoutMinutes;
        if (this.pool != null) {
            this.pool.setIdleTimeoutMinutes(idleTimeoutMinutes);
        }
    }

    public boolean isMatchOne() {
        return this.matchOne;
    }

    public void setMatchOne(boolean matchOne) {
        this.matchOne = matchOne;
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public boolean isSelectOneAssumeMatch() {
        return this.selectOneAssumeMatch;
    }

    public void setSelectOneAssumeMatch(boolean selectOneAssumeMatch) {
        this.selectOneAssumeMatch = selectOneAssumeMatch;
    }

    @Override
    public ConnectionInterceptor addPoolingInterceptors(ConnectionInterceptor tail) {
        if (this.isMatchAll()) {
            SinglePoolMatchAllConnectionInterceptor pool = new SinglePoolMatchAllConnectionInterceptor(tail, this.getMaxSize(), this.getMinSize(), this.getBlockingTimeoutMilliseconds(), this.getIdleTimeoutMinutes());
            this.pool = pool;
            return pool;
        }
        SinglePoolConnectionInterceptor pool = new SinglePoolConnectionInterceptor(tail, this.getMaxSize(), this.getMinSize(), this.getBlockingTimeoutMilliseconds(), this.getIdleTimeoutMinutes(), this.isSelectOneAssumeMatch());
        this.pool = pool;
        return pool;
    }

    @Override
    public int getPartitionCount() {
        return 1;
    }

    @Override
    public int getPartitionMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        if (this.pool != null) {
            this.pool.setPartitionMaxSize(maxSize);
        }
        this.maxSize = maxSize;
    }

    @Override
    public int getPartitionMinSize() {
        return this.minSize;
    }

    @Override
    public void setPartitionMinSize(int minSize) {
        if (this.pool != null) {
            this.pool.setPartitionMinSize(minSize);
        }
        this.minSize = minSize;
    }

    @Override
    public int getIdleConnectionCount() {
        return this.pool == null ? 0 : this.pool.getIdleConnectionCount();
    }

    @Override
    public int getConnectionCount() {
        return this.pool == null ? 0 : this.pool.getConnectionCount();
    }
}

