/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.smallrye.metrics.MetricProducer;
import io.smallrye.metrics.MetricRegistryProducer;
import io.smallrye.metrics.MetricsRequestHandler;
import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIBeanInfoAdapter;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.legacyapi.AnnotatedTypeDecorator;
import io.smallrye.metrics.legacyapi.interceptors.CountedInterceptor;
import io.smallrye.metrics.legacyapi.interceptors.GaugeRegistrationInterceptor;
import io.smallrye.metrics.legacyapi.interceptors.MetricNameFactory;
import io.smallrye.metrics.legacyapi.interceptors.MetricResolver;
import io.smallrye.metrics.legacyapi.interceptors.MetricsBinding;
import io.smallrye.metrics.legacyapi.interceptors.TimedInterceptor;
import io.smallrye.metrics.setup.MetricsMetadata;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class LegacyMetricsExtension
implements Extension {
    private static final String CLASS_NAME = LegacyMetricsExtension.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private final Map<Bean<?>, List<AnnotatedMember<?>>> metricsFromAnnotatedMethods = new HashMap();
    private final List<MetricID> metricIDs = new ArrayList<MetricID>();
    private final List<Class<?>> metricsInterfaces = new ArrayList();
    private static final AnnotationLiteral<MetricsBinding> METRICS_BINDING = new AnnotationLiteral<MetricsBinding>(){};

    public void logVersion(@Observes BeforeBeanDiscovery bbd) {
        String METHOD_NAME = "logVersion";
        LOGGER.logp(Level.INFO, CLASS_NAME, "logVersion", "MicroProfile: Metrics activated (SmallRye Metrics version: {0})", this.getImplementationVersion().orElse("unknown"));
    }

    private Optional<String> getImplementationVersion() {
        String METHOD_NAME = "getImplementationVersion";
        return AccessController.doPrivileged(new PrivilegedAction<Optional<String>>(){

            @Override
            public Optional<String> run() {
                Properties properties = new Properties();
                try {
                    InputStream resource = this.getClass().getClassLoader().getResourceAsStream("project.properties");
                    if (resource != null) {
                        properties.load(resource);
                        return Optional.ofNullable(properties.getProperty("smallrye.metrics.version"));
                    }
                }
                catch (IOException e) {
                    LOGGER.logp(Level.WARNING, CLASS_NAME, "getImplementationVersion", "Unable to detect version of SmallRye Metrics");
                }
                return Optional.empty();
            }
        });
    }

    public void registerAnnotatedTypes(@Observes BeforeBeanDiscovery bbd, BeanManager manager) {
        String extensionName = LegacyMetricsExtension.class.getName();
        for (Class clazz : new Class[]{MetricProducer.class, MetricNameFactory.class, MetricRegistryProducer.class, MetricsRequestHandler.class, CountedInterceptor.class, GaugeRegistrationInterceptor.class, TimedInterceptor.class}) {
            bbd.addAnnotatedType(manager.createAnnotatedType(clazz), extensionName + "_" + clazz.getName());
        }
    }

    public void registerAnnotatedTypesProxy(BeforeBeanDiscovery bbd, BeanManager manager) {
        String extensionName = LegacyMetricsExtension.class.getName();
        for (Class clazz : new Class[]{MetricsRequestHandler.class, CountedInterceptor.class, GaugeRegistrationInterceptor.class, TimedInterceptor.class}) {
            bbd.addAnnotatedType(manager.createAnnotatedType(clazz), extensionName + "_" + clazz.getName());
        }
    }

    public <X> void findAnnotatedInterfaces(@Observes @WithAnnotations(value={Counted.class, Gauge.class, Timed.class}) ProcessAnnotatedType<X> pat) {
        Class clazz = pat.getAnnotatedType().getJavaClass();
        Package pack = clazz.getPackage();
        if (pack != null && pack.getName().equals(GaugeRegistrationInterceptor.class.getPackage().getName())) {
            return;
        }
        if (clazz.isInterface()) {
            this.metricsInterfaces.add(clazz);
        }
    }

    public <X> void applyMetricsBinding(@Observes @WithAnnotations(value={Gauge.class}) ProcessAnnotatedType<X> pat) {
        Class clazz = pat.getAnnotatedType().getJavaClass();
        Package pack = clazz.getPackage();
        if (!(pack != null && pack.getName().equals(GaugeRegistrationInterceptor.class.getPackage().getName()) || clazz.isInterface())) {
            AnnotatedTypeDecorator newPAT = new AnnotatedTypeDecorator(pat.getAnnotatedType(), (Annotation)METRICS_BINDING);
            pat.setAnnotatedType(newPAT);
        }
    }

    public <X> void findAnnotatedMethods(@Observes ProcessManagedBean<X> bean) {
        Package pack = bean.getBean().getBeanClass().getPackage();
        if (pack != null && pack.equals(CountedInterceptor.class.getPackage())) {
            return;
        }
        ArrayList<AnnotatedMethod> list = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod aMethod : bean.getAnnotatedBeanClass().getMethods()) {
            Method method = aMethod.getJavaMember();
            if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
            list.add(aMethod);
        }
        list.addAll(bean.getAnnotatedBeanClass().getConstructors());
        if (!list.isEmpty()) {
            this.metricsFromAnnotatedMethods.put(bean.getBean(), list);
        }
    }

    public void registerMetrics(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        MetricRegistry baseRegistry = SharedMetricRegistries.getOrCreate("base");
        MetricRegistry registry = SharedMetricRegistries.getOrCreate("application");
        CDIBeanInfoAdapter beanInfoAdapter = new CDIBeanInfoAdapter();
        CDIMemberInfoAdapter<Member> memberInfoAdapter = new CDIMemberInfoAdapter<Member>();
        MetricResolver resolver = new MetricResolver();
        for (Map.Entry<Bean<?>, List<AnnotatedMember<?>>> entry : this.metricsFromAnnotatedMethods.entrySet()) {
            Bean<?> bean = entry.getKey();
            for (AnnotatedMember<?> method : entry.getValue()) {
                this.metricIDs.addAll(MetricsMetadata.registerMetrics(registry, resolver, beanInfoAdapter.convert(bean.getBeanClass()), memberInfoAdapter.convert(method.getJavaMember())));
            }
        }
        if (!this.metricsInterfaces.isEmpty()) {
            for (Class clazz : this.metricsInterfaces) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
                    this.metricIDs.addAll(MetricsMetadata.registerMetrics(registry, resolver, beanInfoAdapter.convert(clazz), memberInfoAdapter.convert(method)));
                }
            }
        }
        this.metricsInterfaces.clear();
        this.metricsFromAnnotatedMethods.clear();
    }

    public void addMetricIds(List<MetricID> metricIDList) {
        this.metricIDs.addAll(metricIDList);
    }

    public void addMetricId(MetricID metricID) {
        this.metricIDs.add(metricID);
    }

    void unregisterMetrics(@Observes BeforeShutdown shutdown) {
        MetricRegistry registry = SharedMetricRegistries.getOrCreate("application");
        this.metricIDs.forEach(metricId -> registry.remove(metricId));
    }
}

