/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.json.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.json.JsonService;
import org.apache.fulcrum.json.gson.DateTypeAdapter;

public class GSONBuilderService
extends AbstractLogEnabled
implements JsonService,
Initializable,
Configurable {
    private static final String GLOBAL_ADAPTERS = "globalAdapters";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String USEJSONPATH = "useJsonPath";
    private String dateFormat;
    private Hashtable<String, String> adapters = null;
    private boolean useJsonPath = false;
    GsonBuilder gson;

    public String ser(Object src) throws Exception {
        this.getLogger().debug("ser" + src);
        return this.gson.create().toJson(src);
    }

    public <T> String ser(Object src, Class<T> type) throws Exception {
        this.getLogger().debug("ser::" + src + " with type" + type);
        Type collectionType = new TypeToken<T>(){}.getType();
        return this.gson.create().toJson(src, collectionType);
    }

    public <T> T deSer(String json, Class<T> type) throws Exception {
        this.getLogger().debug("deser:" + json);
        return (T)this.gson.create().fromJson(json, type);
    }

    public <T> Collection<T> deSerCollection(String json, Object collectionType, Class<T> elementType) throws Exception {
        this.getLogger().debug("deser:" + json);
        this.getLogger().debug("collectionType:" + collectionType);
        return (Collection)this.gson.create().fromJson(json, (Type)collectionType);
    }

    public String serializeOnlyFilter(Object src, String ... filterAttr) throws Exception {
        return this.gson.addSerializationExclusionStrategy(this.include(null, filterAttr)).create().toJson(src);
    }

    public String serializeOnlyFilter(Object src, Boolean notused, String ... filterAttr) throws Exception {
        return this.gson.addSerializationExclusionStrategy(this.include(null, filterAttr)).create().toJson(src);
    }

    public <T> String serializeOnlyFilter(Object src, Class<T> filterClass, String ... filterAttr) throws Exception {
        return this.gson.addSerializationExclusionStrategy(this.include(filterClass, filterAttr)).create().toJson(src);
    }

    public <T> String serializeOnlyFilter(Object arg0, Class<T> arg1, Boolean arg2, String ... arg3) throws Exception {
        throw new Exception("Not yet implemented!");
    }

    public JsonService addAdapter(String name, Class target, Object adapter) throws Exception {
        this.gson.registerTypeAdapter((Type)target, adapter);
        return this;
    }

    public JsonService addAdapter(String name, Class target, Class adapter) throws Exception {
        this.gson.registerTypeAdapter((Type)target, adapter.getConstructor(new Class[0]).newInstance(new Object[0]));
        return null;
    }

    public <T> String serializeAllExceptFilter(Object src, Class<T> filterClass, String ... filterAttr) throws Exception {
        return this.gson.addSerializationExclusionStrategy(this.exclude(filterClass, filterAttr)).create().toJson(src);
    }

    public <T> String serializeAllExceptFilter(Object src, Class<T> filterClass, Boolean clearCache, String ... filterAttr) throws Exception {
        throw new Exception("Not yet implemented!");
    }

    public String serializeAllExceptFilter(Object src, String ... filterAttr) throws Exception {
        return this.gson.addSerializationExclusionStrategy(this.exclude(null, filterAttr)).create().toJson(src);
    }

    public String serializeAllExceptFilter(Object src, Boolean notused, String ... filterAttr) throws Exception {
        return this.gson.addSerializationExclusionStrategy(this.exclude(null, filterAttr)).create().toJson(src);
    }

    public String ser(Object src, Boolean refreshCache) throws Exception {
        throw new Exception("Not implemented!");
    }

    public <T> String ser(Object src, Class<T> type, Boolean refreshCache) throws Exception {
        throw new Exception("Not implemented!");
    }

    public JsonService registerTypeAdapter(Object serdeser, Type type) {
        this.gson.registerTypeAdapter(type, serdeser);
        return this;
    }

    public void setDateFormat(String dfStr) {
        this.gson.setDateFormat(dfStr);
    }

    public void setDateFormat(DateFormat df) {
        DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
        dateTypeAdapter.setCustomDateFormat(df);
        this.gson.registerTypeAdapter(Date.class, (Object)dateTypeAdapter);
    }

    public void getJsonService() throws InstantiationException {
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration configuredjsonPath;
        Configuration configuredAdapters;
        this.getLogger().debug("conf.getName()" + conf.getName());
        Configuration configuredDateFormat = conf.getChild(DATE_FORMAT, false);
        if (configuredDateFormat != null) {
            this.dateFormat = configuredDateFormat.getValue();
        }
        if ((configuredAdapters = conf.getChild(GLOBAL_ADAPTERS, true)) != null) {
            Configuration[] nameVal = configuredAdapters.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String key = nameVal[i].getName();
                this.getLogger().debug("configured key: " + key);
                if (!key.equals("adapter")) continue;
                String forClass = nameVal[i].getAttribute("forClass");
                this.adapters = new Hashtable();
                this.adapters.put(forClass, nameVal[i].getValue());
            }
        }
        if ((configuredjsonPath = conf.getChild(USEJSONPATH, false)) != null) {
            this.useJsonPath = configuredjsonPath.getValueAsBoolean();
        }
    }

    public void initialize() throws Exception {
        this.gson = new GsonBuilder();
        this.getLogger().debug("initialized: gson:" + this.gson);
        if (this.dateFormat != null) {
            this.getLogger().info("setting date format to: " + this.dateFormat);
            this.setDateFormat(new SimpleDateFormat(this.dateFormat));
        }
        if (this.adapters != null) {
            Enumeration<String> enumKey = this.adapters.keys();
            while (enumKey.hasMoreElements()) {
                String forClass = enumKey.nextElement();
                String avClass = this.adapters.get(forClass);
                if (avClass == null) continue;
                try {
                    this.getLogger().debug("initializing: adapters " + avClass + " forClass:" + forClass);
                    Class<?> adapterForClass = Class.forName(forClass);
                    Class<?> adapterClass = Class.forName(avClass);
                    this.addAdapter("Test Adapter", adapterForClass, adapterClass);
                }
                catch (Exception e) {
                    throw new InstantiationException("JsonMapperService: Error instantiating one of the adapters: " + avClass + " for " + forClass);
                }
            }
        }
        if (this.useJsonPath) {
            com.jayway.jsonpath.Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
                private Callable<Gson> gsonFuture = new Callable<Gson>(){

                    @Override
                    public Gson call() {
                        return GSONBuilderService.this.gson.create();
                    }
                };
                private final JsonProvider jsonProvider;
                private final MappingProvider mappingProvider;
                {
                    this.jsonProvider = new GsonJsonProvider(GSONBuilderService.this.gson.create());
                    this.mappingProvider = new GsonMappingProvider(this.gsonFuture);
                }

                public JsonProvider jsonProvider() {
                    return this.jsonProvider;
                }

                public MappingProvider mappingProvider() {
                    return this.mappingProvider;
                }

                public Set<Option> options() {
                    return EnumSet.noneOf(Option.class);
                }
            });
        }
    }

    private ExclusionStrategy exclude(Class clazz, String ... filterAttrs) {
        return (new ExclusionStrategy(){
            public Class<?> excludedThisClass;
            public HashSet<String> excludedAttributes;

            private ExclusionStrategy init(Class<?> excludedThisClass, String ... filterAttrs) {
                this.excludedThisClass = excludedThisClass;
                if (filterAttrs != null) {
                    this.excludedAttributes = new HashSet(filterAttrs.length);
                    Collections.addAll(this.excludedAttributes, filterAttrs);
                } else {
                    this.excludedAttributes = new HashSet();
                }
                return this;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return this.excludedThisClass != null ? this.excludedThisClass.equals(clazz) : false;
            }

            public boolean shouldSkipField(FieldAttributes paramFieldAttributes) {
                return !this.excludedAttributes.isEmpty() ? this.excludedAttributes.contains(paramFieldAttributes.getName()) : false;
            }
        }).init(clazz, filterAttrs);
    }

    private ExclusionStrategy include(Class clazz, String ... filterAttrs) {
        return (new ExclusionStrategy(){
            private Class<?> includeThisClass;
            private HashSet<String> includedAttributes;

            private ExclusionStrategy init(Class<?> includeThisClass, String ... filterAttrs) {
                this.includeThisClass = includeThisClass;
                if (filterAttrs != null) {
                    this.includedAttributes = new HashSet(filterAttrs.length);
                    GSONBuilderService.this.getLogger().debug(" ... adding includedAttributes:" + filterAttrs.length);
                    Collections.addAll(this.includedAttributes, filterAttrs);
                    for (String includedAttribute : this.includedAttributes) {
                        GSONBuilderService.this.getLogger().debug("includedAttribute:" + includedAttribute);
                    }
                } else {
                    this.includedAttributes = new HashSet();
                }
                return this;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                GSONBuilderService.this.getLogger().debug(this.includeThisClass + ": comparing include class:" + clazz);
                return this.includeThisClass != null ? !this.includeThisClass.equals(clazz) : false;
            }

            public boolean shouldSkipField(FieldAttributes paramFieldAttributes) {
                return !this.includedAttributes.isEmpty() ? !this.includedAttributes.contains(paramFieldAttributes.getName()) : true;
            }
        }).init(clazz, filterAttrs);
    }
}

