/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.basic;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.basic.entity.BasicUser;
import org.apache.fulcrum.security.torque.om.TorqueBasicUserGroup;
import org.apache.fulcrum.security.torque.om.TorqueBasicUserGroupPeer;
import org.apache.fulcrum.security.torque.om.TorqueBasicUserPeer;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class TorqueAbstractBasicUser
extends TorqueAbstractSecurityEntity
implements BasicUser {
    private static final long serialVersionUID = 7669398253522416329L;
    private Set<Group> groupSet = null;

    protected List<TorqueBasicUserGroup> getTorqueBasicUserGroupsJoinTorqueBasicGroup(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueBasicUserGroupPeer.USER_ID, (Object)this.getEntityId());
        return TorqueBasicUserGroupPeer.doSelectJoinTorqueBasicGroup(criteria, con);
    }

    public void addGroup(Group group) {
        this.getGroups().add((SecurityEntity)group);
    }

    public GroupSet getGroups() {
        if (this.groupSet == null) {
            this.groupSet = new GroupSet();
        } else if (!(this.groupSet instanceof GroupSet)) {
            this.groupSet = new GroupSet(this.groupSet);
        }
        return (GroupSet)this.groupSet;
    }

    public <T extends Group> Set<T> getGroupsAsSet() {
        return this.groupSet;
    }

    public void removeGroup(Group group) {
        this.getGroups().remove((Object)group);
    }

    public void setGroups(GroupSet groups) {
        this.groupSet = groups != null ? groups : new GroupSet();
    }

    public <T extends Group> void setGroupsAsSet(Set<T> groups) {
        this.setGroups(new GroupSet(groups));
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.groupSet = new GroupSet();
        try {
            List<TorqueBasicUserGroup> usergroups = this.getTorqueBasicUserGroupsJoinTorqueBasicGroup(new Criteria(), con);
            for (TorqueBasicUserGroup tbug : usergroups) {
                this.groupSet.add((Group)tbug.getTorqueBasicGroup());
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(Connection con) throws TorqueException {
        if (this.groupSet != null) {
            Criteria criteria = new Criteria();
            criteria.where((Object)TorqueBasicUserGroupPeer.USER_ID, (Object)this.getEntityId());
            TorqueBasicUserGroupPeer.doDelete(criteria, con);
            for (Group g : this.groupSet) {
                TorqueBasicUserGroup ug = new TorqueBasicUserGroup();
                ug.setUserId(this.getEntityId());
                ug.setGroupId((Integer)g.getId());
                ug.save(con);
            }
        }
        try {
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public String getDatabaseName() {
        return TorqueBasicUserPeer.DATABASE_NAME;
    }

    @Override
    public void delete() throws TorqueException {
        TorqueBasicUserPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

