/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.dynamic;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegates;
import org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroup;
import org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class TorqueAbstractDynamicUser
extends TorqueAbstractSecurityEntity
implements DynamicUser {
    private static final long serialVersionUID = -7307211992287876455L;
    private Set<Group> groupSet = null;
    private Set<User> delegators = null;
    private Set<User> delegatees = null;

    protected List<TorqueDynamicUserGroup> getTorqueDynamicUserGroupsJoinTorqueDynamicGroup(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueDynamicUserGroupPeer.USER_ID, (Object)this.getEntityId());
        return TorqueDynamicUserGroupPeer.doSelectJoinTorqueDynamicGroup(criteria, con);
    }

    protected List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatessRelatedByDelegateeUserIdJoinTorqueDynamicUserRelatedByDelegatorUserId(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, (Object)this.getEntityId());
        return TorqueDynamicUserDelegatesPeer.doSelectJoinTorqueDynamicUserRelatedByDelegatorUserId(criteria, con);
    }

    protected List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatessRelatedByDelegatorUserIdJoinTorqueDynamicUserRelatedByDelegateeUserId(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, (Object)this.getEntityId());
        return TorqueDynamicUserDelegatesPeer.doSelectJoinTorqueDynamicUserRelatedByDelegateeUserId(criteria, con);
    }

    public void addGroup(Group group) {
        this.getGroups().add((SecurityEntity)group);
    }

    public GroupSet getGroups() {
        if (this.groupSet == null) {
            this.groupSet = new GroupSet();
        } else if (!(this.groupSet instanceof GroupSet)) {
            this.groupSet = new GroupSet(this.groupSet);
        }
        return (GroupSet)this.groupSet;
    }

    public <T extends Group> Set<T> getGroupsAsSet() {
        return this.groupSet;
    }

    public void removeGroup(Group group) {
        this.getGroups().remove((Object)group);
    }

    public void setGroups(GroupSet groups) {
        this.groupSet = groups != null ? groups : new GroupSet();
    }

    public <T extends Group> void setGroupsAsSet(Set<T> groups) {
        this.setGroups(new GroupSet(groups));
    }

    public <T extends User> Set<T> getDelegatees() {
        if (this.delegatees == null) {
            this.delegatees = new UserSet();
        }
        return this.delegatees;
    }

    public <T extends User> Set<T> getDelegators() {
        if (this.delegators == null) {
            this.delegators = new UserSet();
        }
        return this.delegators;
    }

    public <T extends User> void setDelegatees(Set<T> delegatees) {
        this.delegatees = delegatees != null ? new UserSet(delegatees) : new UserSet();
    }

    public <T extends User> void setDelegators(Set<T> delegates) {
        this.delegators = this.delegators != null ? new UserSet(delegates) : new UserSet();
    }

    public String getDatabaseName() {
        return TorqueDynamicUserPeer.DATABASE_NAME;
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.groupSet = new GroupSet();
        try {
            List<TorqueDynamicUserGroup> usergroups = this.getTorqueDynamicUserGroupsJoinTorqueDynamicGroup(new Criteria(), con);
            for (TorqueDynamicUserGroup torqueDynamicUserGroup : usergroups) {
                this.groupSet.add((Group)torqueDynamicUserGroup.getTorqueDynamicGroup());
            }
            this.delegators = new UserSet();
            List<TorqueDynamicUserDelegates> delegatorlist = this.getTorqueDynamicUserDelegatessRelatedByDelegateeUserIdJoinTorqueDynamicUserRelatedByDelegatorUserId(new Criteria(), con);
            for (TorqueDynamicUserDelegates tdud : delegatorlist) {
                this.delegators.add((User)tdud.getTorqueDynamicUserRelatedByDelegatorUserId());
            }
            this.delegatees = new UserSet();
            List<TorqueDynamicUserDelegates> list = this.getTorqueDynamicUserDelegatessRelatedByDelegatorUserIdJoinTorqueDynamicUserRelatedByDelegateeUserId(new Criteria(), con);
            for (TorqueDynamicUserDelegates tdud : list) {
                this.delegatees.add((User)tdud.getTorqueDynamicUserRelatedByDelegateeUserId());
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(Connection con) throws TorqueException {
        TorqueDynamicUserDelegates ud;
        Criteria criteria;
        if (this.groupSet != null) {
            criteria = new Criteria();
            criteria.where((Object)TorqueDynamicUserGroupPeer.USER_ID, (Object)this.getEntityId());
            TorqueDynamicUserGroupPeer.doDelete(criteria, con);
            for (Group g : this.groupSet) {
                TorqueDynamicUserGroup ug = new TorqueDynamicUserGroup();
                ug.setUserId(this.getEntityId());
                ug.setGroupId((Integer)g.getId());
                ug.save(con);
            }
        }
        if (this.delegators != null) {
            criteria = new Criteria();
            criteria.where((Object)TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, (Object)this.getEntityId());
            TorqueDynamicUserDelegatesPeer.doDelete(criteria, con);
            for (User u : this.delegators) {
                ud = new TorqueDynamicUserDelegates();
                ud.setDelegateeUserId(this.getEntityId());
                ud.setDelegatorUserId((Integer)u.getId());
                ud.save(con);
            }
        }
        if (this.delegatees != null) {
            criteria = new Criteria();
            criteria.where((Object)TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, (Object)this.getEntityId());
            TorqueDynamicUserDelegatesPeer.doDelete(criteria, con);
            for (User u : this.delegatees) {
                ud = new TorqueDynamicUserDelegates();
                ud.setDelegatorUserId(this.getEntityId());
                ud.setDelegateeUserId((Integer)u.getId());
                ud.save(con);
            }
        }
        try {
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    @Override
    public void delete() throws TorqueException {
        TorqueDynamicUserPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

