/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.peer.managers;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fulcrum.security.torque.TorqueAbstractGroupManager;
import org.apache.fulcrum.security.torque.peer.Peer;
import org.apache.fulcrum.security.torque.peer.PeerManagable;
import org.apache.fulcrum.security.torque.peer.PeerManager;
import org.apache.fulcrum.security.torque.peer.TorqueTurbinePeer;
import org.apache.fulcrum.security.util.DataBackendException;

public abstract class PeerGroupManager
extends TorqueAbstractGroupManager
implements PeerManagable {
    private Boolean customPeer = false;
    private String peerClassName;
    transient PeerManager peerManager;
    private static final String PEER_CLASS_NAME_KEY = "peerClassName";
    private String columnName = "GROUP_NAME";

    @Override
    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.peerClassName = conf.getChild(PEER_CLASS_NAME_KEY).getValue(null);
        if (this.peerClassName != null) {
            this.setPeerClassName(this.peerClassName);
            this.setCustomPeer(true);
        }
    }

    @Override
    public Peer getPeerInstance() throws DataBackendException {
        return this.getPeerManager().getPeerInstance(this.getPeerClassName(), TorqueTurbinePeer.class, this.getClassName());
    }

    @Override
    public PeerManager getPeerManager() {
        if (this.peerManager == null) {
            this.peerManager = (PeerManager)this.resolve(PeerManager.ROLE);
        }
        return this.peerManager;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Boolean getCustomPeer() {
        return this.customPeer;
    }

    @Override
    public void setCustomPeer(Boolean customPeer) {
        this.customPeer = customPeer;
    }

    @Override
    public String getPeerClassName() {
        return this.peerClassName;
    }

    @Override
    public void setPeerClassName(String peerClassName) {
        this.peerClassName = peerClassName;
    }
}

