/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.basic.test;

import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.basic.BasicModelManager;
import org.apache.fulcrum.security.model.basic.entity.BasicGroup;
import org.apache.fulcrum.security.model.basic.entity.BasicUser;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractModelManagerTest
extends BaseUnit5Test {
    protected Role role;
    protected BasicModelManager modelManager;
    protected GroupManager groupManager;
    protected UserManager userManager;
    protected SecurityService securityService;

    @BeforeEach
    public void setUp() throws Exception {
        this.userManager = this.securityService.getUserManager();
        this.groupManager = this.securityService.getGroupManager();
        this.modelManager = (BasicModelManager)this.securityService.getModelManager();
    }

    @Test
    public void testRevokeAllUser() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKEALL");
        this.securityService.getGroupManager().addGroup(group);
        Group group2 = this.securityService.getGroupManager().getGroupInstance();
        group2.setName("TEST_REVOKEALL2");
        this.securityService.getGroupManager().addGroup(group2);
        User user = this.userManager.getUserInstance("Clint2");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group);
        this.modelManager.grant(user, group2);
        this.modelManager.revokeAll(user);
        Assertions.assertEquals((int)0, (int)((BasicUser)user).getGroups().size());
        group = this.securityService.getGroupManager().getGroupByName("TEST_REVOKEALL");
        group2 = this.securityService.getGroupManager().getGroupByName("TEST_REVOKEALL2");
        Assertions.assertFalse((boolean)((BasicGroup)group).getUsersAsSet().contains(user));
        Assertions.assertFalse((boolean)((BasicGroup)group2).getUsers().contains((Object)user));
    }

    @Test
    public void testGrantUserGroup() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Clint");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group);
        Assertions.assertTrue((boolean)((BasicUser)user).getGroups().contains((Object)group));
        Assertions.assertTrue((boolean)((BasicGroup)group).getUsers().contains((Object)user));
    }

    @Test
    public void testRevokeUserGroup() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKE");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Lima");
        this.userManager.addUser(user, "pet");
        this.modelManager.revoke(user, group);
        Assertions.assertFalse((boolean)((BasicUser)user).getGroups().contains((Object)group));
        Assertions.assertFalse((boolean)((BasicGroup)group).getUsers().contains((Object)user));
        user = this.userManager.getUser("Lima");
        Assertions.assertFalse((boolean)((BasicUser)user).getGroups().contains((Object)group));
    }
}

