/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;

public class LocalizationTool
implements ApplicationTool {
    private static Log log = LogFactory.getLog((Class)LocalizationTool.class);
    protected Locale locale;
    protected String bundleName;

    public LocalizationTool() {
        this.refresh();
    }

    public String get(String key) {
        try {
            return Localization.getString(this.getBundleName(null), this.getLocale(), key);
        }
        catch (MissingResourceException noKey) {
            log.error((Object)noKey);
            return null;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String getBundleName(Object data) {
        return this.bundleName;
    }

    public String format(String key, Object arg1) {
        return Localization.format(this.getBundleName(null), this.getLocale(), key, arg1);
    }

    public String format(String key, Object arg1, Object arg2) {
        return Localization.format(this.getBundleName(null), this.getLocale(), key, arg1, arg2);
    }

    public String format(String key, Object[] args) {
        return Localization.format(this.getBundleName(null), this.getLocale(), key, args);
    }

    public String format(String key, List args) {
        return Localization.format(this.getBundleName(null), this.getLocale(), key, args.toArray());
    }

    public void init(Object data) {
        if (data instanceof RunData) {
            this.locale = Localization.getLocale(((RunData)data).getRequest());
            this.bundleName = Localization.getDefaultBundleName();
        }
    }

    public void refresh() {
        this.locale = null;
        this.bundleName = null;
    }
}

