/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.uniqueid;

import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.uniqueid.UniqueIdService;
import org.apache.turbine.util.GenerateUniqueId;
import org.apache.turbine.util.RunData;

public class TurbineUniqueIdService
extends TurbineBaseService
implements UniqueIdService {
    private static Log log = LogFactory.getLog((Class)TurbineUniqueIdService.class);
    protected static String turbineId = "UNKNOWN";
    protected static String turbineURL = "UNKNOWN";
    protected static int counter;

    public void init(RunData data) throws InitializationException {
        this.init();
    }

    public void init() throws InitializationException {
        try {
            String url = Turbine.getDefaultServerData().toString();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytesId = md.digest(url.getBytes("UTF-8"));
            turbineId = new String(Base64.encodeBase64((byte[])bytesId));
            log.info((Object)("This is Turbine instance running at: " + url));
            log.info((Object)("The instance id is #" + turbineId));
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Could not initialize TurbineUniqueId Service", e);
        }
    }

    public void shutdown() {
        log.info((Object)("Turbine instance running at " + turbineURL + " shutting down."));
    }

    public String getInstanceId() {
        return turbineId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueId() {
        int current;
        Class clazz = TurbineUniqueIdService.class;
        synchronized (clazz) {
            current = counter++;
        }
        String id = Integer.toString(current);
        if (current < 100000000) {
            id = ("00000000" + id).substring(id.length());
        }
        return id;
    }

    public String getPseudorandomId() {
        return GenerateUniqueId.getIdentifier();
    }
}

