/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.fulcrum.parser.ValueParser;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.AnnotationProcessor;
import org.apache.turbine.annotation.TurbineActionEvent;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.modules.Action;
import org.apache.turbine.pipeline.PipelineData;

public abstract class ActionEvent
extends Action {
    protected Log log = LogFactory.getLog(this.getClass());
    protected static final String BUTTON = "eventSubmit_";
    protected static final int BUTTON_LENGTH = "eventSubmit_".length();
    protected static final String DEFAULT_METHOD = "doPerform";
    protected static final String METHOD_NAME_PREFIX = "do";
    protected static final int METHOD_NAME_LENGTH = "do".length();
    protected static final int LENGTH = "eventSubmit_".length();
    @TurbineConfiguration(value="action.eventsubmit.needsvalue")
    private boolean submitValueKey = false;
    @TurbineConfiguration(value="action.event.bubbleexception")
    protected boolean bubbleUpException = true;
    private MultiKeyMap methodCache = new MultiKeyMap();

    protected Method getMethod(String name, Class<?>[] signature, ParameterParser pp) throws NoSuchMethodException {
        Method method = (Method)this.methodCache.get((Object)name, signature);
        if (method == null) {
            Method[] methods;
            block0: for (Method m : methods = this.getClass().getMethods()) {
                Annotation[] annotations;
                for (Annotation a : annotations = AnnotationProcessor.getAnnotations(m)) {
                    TurbineActionEvent tae;
                    if (!(a instanceof TurbineActionEvent) || !name.equals(pp.convert((tae = (TurbineActionEvent)a).value())) || !Arrays.equals(signature, m.getParameterTypes())) continue;
                    method = m;
                    break block0;
                }
            }
            if (method == null) {
                String tmp = name.toLowerCase().substring(METHOD_NAME_LENGTH);
                method = this.getClass().getMethod(METHOD_NAME_PREFIX + StringUtils.capitalize((String)tmp), signature);
            }
            this.methodCache.put((Object)name, signature, (Object)method);
        }
        return method;
    }

    @Override
    public void doPerform(PipelineData pipelineData) throws Exception {
        ParameterParser pp = pipelineData.get(Turbine.class, ParameterParser.class);
        this.executeEvents(pp, new Class[]{PipelineData.class}, new Object[]{pipelineData});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeEvents(ParameterParser pp, Class<?>[] signature, Object[] parameters) throws Exception {
        String theButton = null;
        String button = pp.convert(BUTTON);
        String key = null;
        for (String k : pp) {
            key = k;
            if (!key.startsWith(button) || !this.considerKey(key, pp)) continue;
            theButton = key;
            break;
        }
        if (theButton == null) {
            theButton = "eventSubmit_doPerform";
            key = null;
        }
        theButton = this.formatString(theButton, pp);
        Method method = null;
        try {
            method = this.getMethod(theButton, signature, pp);
        }
        catch (NoSuchMethodException e) {
            method = this.getMethod(DEFAULT_METHOD, signature, pp);
        }
        finally {
            if (key != null) {
                pp.remove(key);
            }
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + method));
            }
            method.invoke((Object)this, parameters);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (this.bubbleUpException) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw ite;
            }
            this.log.error((Object)("Invokation of " + method), t);
        }
    }

    protected String formatString(String input, ParameterParser pp) {
        String tmp = input;
        if (StringUtils.isNotEmpty((String)input)) {
            tmp = input.toLowerCase();
            String methodName = tmp.endsWith(".x") || tmp.endsWith(".y") ? input.substring(0, input.length() - 2) : input;
            tmp = pp.getUrlFolding() == ValueParser.URLCaseFolding.NONE ? methodName.substring(BUTTON_LENGTH) : methodName.toLowerCase().substring(BUTTON_LENGTH);
        }
        return tmp;
    }

    protected boolean considerKey(String key, ParameterParser pp) {
        if (!this.submitValueKey) {
            this.log.debug((Object)("No Value required, accepting " + key));
            return true;
        }
        String keyValue = pp.getString(key);
        this.log.debug((Object)("Key Value is " + keyValue));
        if (StringUtils.isEmpty((String)keyValue)) {
            this.log.debug((Object)("Key is empty, rejecting " + key));
            return false;
        }
        try {
            if (Integer.parseInt(keyValue) != 0) {
                this.log.debug((Object)("Integer != 0, accepting " + key));
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            this.log.debug((Object)("Not a number, accepting " + key));
            return true;
        }
        this.log.debug((Object)("Rejecting " + key));
        return false;
    }
}

