/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull.util;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.fulcrum.localization.LocalizationService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.localization.DateTimeFormatterInterface;
import org.apache.turbine.services.localization.DateTimeFormatterService;
import org.apache.turbine.services.pull.util.DateFormatter;
import org.apache.turbine.util.RunData;

public class DateTimeFormatterTool
extends DateFormatter
implements DateTimeFormatterInterface {
    @TurbineService
    private DateTimeFormatterService dtfs;
    private static final Logger log = LogManager.getLogger(DateTimeFormatterTool.class);
    @TurbineService
    private LocalizationService localizationService;
    protected Locale locale;
    private boolean overrideFromRequestLocale = false;

    @Override
    public void init(Object data) {
        log.info("Initializing DateTimeFormatterTool with service {}", (Object)this.dtfs);
        if (this.dtfs == null) {
            ServiceManager serviceManager = TurbineServices.getInstance();
            this.dtfs = (DateTimeFormatterService)serviceManager.getService("Service");
        }
        this.overrideFromRequestLocale = Turbine.getConfiguration().getBoolean("tool.use.request.locale", false);
        if (this.overrideFromRequestLocale && data instanceof RunData) {
            this.locale = this.localizationService.getLocale(((RunData)data).getRequest());
            log.info("Override {} with request locale {} from {}", (Object)this.dtfs.getLocale(), (Object)this.locale, (Object)this.localizationService);
        }
    }

    public DateTimeFormatterService getDtfs() {
        return this.dtfs;
    }

    @Override
    public void refresh() {
    }

    @Override
    public DateTimeFormatter getDefaultFormat() {
        return this.getDtfs().getDefaultFormat();
    }

    @Override
    public String getFormatPattern() {
        return this.getDtfs().getFormatPattern();
    }

    @Override
    public <T extends TemporalAccessor> String format(T temporalAccessor) {
        return this.getDtfs().format(temporalAccessor, this.getDtfs().getFormatPattern(), this.getLocale());
    }

    @Override
    public <T extends TemporalAccessor> String format(T temporalAccessor, String dateFormatString) {
        return this.getDtfs().format(temporalAccessor, dateFormatString, this.getLocale());
    }

    @Override
    public <T extends TemporalAccessor> String format(T temporalAccessor, String dateFormatString, Locale locale) {
        return this.getDtfs().format(temporalAccessor, dateFormatString, locale);
    }

    @Override
    public <T extends TemporalAccessor> String format(T temporalAccessor, String dateFormatString, Locale locale, ZoneId zoneId) {
        return this.getDtfs().format(temporalAccessor, dateFormatString, locale, zoneId);
    }

    @Override
    public String map(String src, String outgoingFormatPattern, Locale locale, String incomingFormatPattern) {
        return this.getDtfs().map(src, outgoingFormatPattern, locale, incomingFormatPattern);
    }

    @Override
    public String map(String src, DateTimeFormatter outgoingFormat, Locale locale, DateTimeFormatter incomingFormat) {
        return this.getDtfs().map(src, outgoingFormat, locale, incomingFormat);
    }

    @Override
    public String mapTo(String src, DateTimeFormatter outgoingFormat) {
        return this.getDtfs().map(src, outgoingFormat, this.getLocale(), this.getDtfs().getDefaultFormat());
    }

    @Override
    public String mapFrom(String src, DateTimeFormatter incomingFormat) {
        return this.getDtfs().map(src, this.getDtfs().getDefaultFormat(), this.getLocale(), incomingFormat);
    }

    @Override
    public String map(String src, DateTimeFormatter outgoingFormat, Locale locale) {
        return this.getDtfs().map(src, outgoingFormat, locale, this.getDtfs().getDefaultFormat());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public ZoneId getZoneId() {
        return this.getDtfs() != null ? this.getDtfs().getZoneId() : ZoneId.systemDefault();
    }
}

