/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.quartz.QuartzScheduler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobEntryQuartz;
import org.apache.turbine.services.schedule.ScheduleService;
import org.apache.turbine.util.TurbineException;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzSchedulerService
extends TurbineBaseService
implements ScheduleService {
    protected static final Logger log = LogManager.getLogger((String)"scheduler");
    protected boolean enabled = false;
    private Scheduler scheduler;

    @Override
    public void init() throws InitializationException {
        this.setEnabled(this.getConfiguration().getBoolean("enabled", true));
        QuartzScheduler qs = (QuartzScheduler)TurbineServices.getInstance().getService(QuartzScheduler.class.getName());
        this.scheduler = qs.getScheduler();
        this.restart();
        this.setInit(true);
    }

    @Override
    public void shutdown() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            log.error("Could not shut down the scheduler service", (Throwable)e);
        }
    }

    @Override
    public JobEntry newJob(int sec, int min, int hour, int wd, int day_mo, String task) throws TurbineException {
        try {
            JobDetail jd = JobBuilder.newJob(JobEntryQuartz.class).withIdentity(task, "TURBINE").build();
            CronScheduleBuilder csb = this.createCronExpression(sec, min, hour, wd, day_mo);
            Trigger t = TriggerBuilder.newTrigger().withIdentity(task, "TURBINE").withSchedule((ScheduleBuilder)csb).forJob(jd).build();
            JobEntryQuartz jeq = new JobEntryQuartz(t, jd);
            return jeq;
        }
        catch (ParseException e) {
            throw new TurbineException("Could not create scheduled job " + task, e);
        }
    }

    private CronScheduleBuilder createCronExpression(int sec, int min, int hour, int wd, int day_mo) throws ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append(sec == -1 ? "*" : String.valueOf(sec)).append(' ');
        sb.append(min == -1 ? "*" : String.valueOf(min)).append(' ');
        sb.append(hour == -1 ? "*" : String.valueOf(hour)).append(' ');
        if (day_mo == -1) {
            sb.append(wd == -1 ? "*" : "?").append(' ');
        } else {
            sb.append(day_mo).append(' ');
        }
        sb.append("* ");
        if (day_mo == -1) {
            sb.append(wd == -1 ? "?" : String.valueOf(wd));
        } else {
            sb.append("*");
        }
        return CronScheduleBuilder.cronSchedule((String)sb.toString());
    }

    @Override
    public JobEntry getJob(int oid) throws TurbineException {
        for (JobEntry jobEntry : this.listJobs()) {
            if (jobEntry.getJobId() != oid) continue;
            return jobEntry;
        }
        throw new TurbineException("Could not retrieve scheduled job with id " + oid);
    }

    @Override
    public void addJob(JobEntry je) throws TurbineException {
        try {
            JobEntryQuartz jq = this.downCast(je);
            this.scheduler.scheduleJob(jq.getJobDetail(), jq.getJobTrigger());
        }
        catch (SchedulerException e) {
            throw new TurbineException("Problem adding Scheduled Job: " + je.getTask(), e);
        }
    }

    @Override
    public void removeJob(JobEntry je) throws TurbineException {
        try {
            JobEntryQuartz jq = this.downCast(je);
            this.scheduler.deleteJob(jq.getJobTrigger().getJobKey());
        }
        catch (SchedulerException e) {
            throw new TurbineException("Problem removing Scheduled Job: " + je.getTask(), e);
        }
    }

    @Override
    public void updateJob(JobEntry je) throws TurbineException {
        try {
            JobEntryQuartz jq = this.downCast(je);
            this.scheduler.rescheduleJob(jq.getJobTrigger().getKey(), jq.getJobTrigger());
        }
        catch (SchedulerException e) {
            throw new TurbineException("Problem updating Scheduled Job: " + je.getTask(), e);
        }
    }

    @Override
    public List<? extends JobEntry> listJobs() {
        ArrayList<JobEntryQuartz> jobs = new ArrayList<JobEntryQuartz>();
        try {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)"TURBINE");
            Set jobKeys = this.scheduler.getJobKeys(groupMatcher);
            for (JobKey jk : jobKeys) {
                List triggers = this.scheduler.getTriggersOfJob(jk);
                if (triggers == null || triggers.isEmpty()) continue;
                JobDetail jd = this.scheduler.getJobDetail(jk);
                JobEntryQuartz job = new JobEntryQuartz((Trigger)triggers.get(0), jd);
                job.setJobId(jk.hashCode());
                jobs.add(job);
            }
        }
        catch (SchedulerException e) {
            log.error("Problem listing Scheduled Jobs", (Throwable)e);
        }
        return jobs;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void startScheduler() {
        this.setEnabled(true);
        this.restart();
    }

    @Override
    public synchronized void stopScheduler() {
        log.info("Stopping job scheduler");
        try {
            this.scheduler.standby();
            this.enabled = false;
        }
        catch (SchedulerException e) {
            log.error("Could not stop scheduler", (Throwable)e);
        }
    }

    public synchronized void restart() {
        if (this.enabled) {
            log.info("Starting job scheduler");
            try {
                if (!this.scheduler.isStarted()) {
                    this.scheduler.start();
                } else {
                    this.notify();
                }
            }
            catch (SchedulerException e) {
                log.error("Could not start scheduler", (Throwable)e);
            }
        }
    }

    private JobEntryQuartz downCast(JobEntry je) throws TurbineException {
        if (je instanceof JobEntryQuartz) {
            return (JobEntryQuartz)je;
        }
        throw new TurbineException("Invalid job type for this scheduler " + String.valueOf(je.getClass()));
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public JobEntryQuartz buildJobEntry(Trigger trigger, JobDetail jd) {
        JobEntryQuartz job = new JobEntryQuartz(trigger, jd);
        return job;
    }
}

