/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.pool;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.pool.ArrayCtorRecyclable;
import org.apache.fulcrum.pool.BoundedBuffer;
import org.apache.fulcrum.pool.PoolException;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.pool.Recycler;

public class PoolBuffer {
    private BoundedBuffer pool;
    private boolean arrayCtorRecyclable;
    private ArrayList<Recycler> recyclers;

    public PoolBuffer(int capacity) {
        this.pool = new BoundedBuffer(capacity);
    }

    public void setArrayCtorRecyclable(boolean isArrayCtor) {
        this.arrayCtorRecyclable = isArrayCtor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(Object[] params, String[] signature, FactoryService factoryService) throws PoolException {
        Object instance;
        block12: {
            instance = this.pool.poll();
            if (instance != null) {
                if (this.arrayCtorRecyclable) {
                    ((ArrayCtorRecyclable)instance).recycle(params);
                } else if (instance instanceof Recyclable) {
                    try {
                        if (signature != null && signature.length > 0) {
                            Method recycle = this.getRecycle(signature);
                            if (recycle == null) {
                                PoolBuffer poolBuffer = this;
                                synchronized (poolBuffer) {
                                    recycle = this.getRecycle(signature);
                                    if (recycle == null) {
                                        Class<?> clazz = instance.getClass();
                                        recycle = clazz.getMethod("recycle", factoryService.getSignature(clazz, params, signature));
                                        ArrayList cache = this.recyclers != null ? (ArrayList)this.recyclers.clone() : new ArrayList();
                                        cache.add(new Recycler(recycle, signature));
                                        this.recyclers = cache;
                                    }
                                }
                            }
                            recycle.invoke(instance, params);
                            break block12;
                        }
                        ((Recyclable)instance).recycle();
                    }
                    catch (Exception x) {
                        throw new PoolException("Recycling failed for " + instance.getClass().getName(), x);
                    }
                }
            }
        }
        return instance;
    }

    public boolean offer(Object instance) {
        if (instance instanceof Recyclable) {
            try {
                ((Recyclable)instance).dispose();
            }
            catch (Exception x) {
                return false;
            }
        }
        return this.pool.offer(instance);
    }

    public int capacity() {
        return this.pool.capacity();
    }

    public int size() {
        return this.pool.size();
    }

    private Method getRecycle(String[] signature) {
        ArrayList<Recycler> cache = this.recyclers;
        if (cache != null) {
            for (Recycler recycler : cache) {
                Method recycle = recycler.match(signature);
                if (recycle == null) continue;
                return recycle;
            }
        }
        return null;
    }
}

