/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.utils.update;

import java.util.ArrayList;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.ui.wizards.RutaProjectCreationWizard;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.utils.ResourceUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertProjectHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        new ConvertProjectHandlerJob(event).schedule();
        return Status.OK_STATUS;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    private class ConvertProjectHandlerJob
    extends Job {
        ExecutionEvent event;

        ConvertProjectHandlerJob(ExecutionEvent event) {
            super("Converting...");
            this.event = event;
            this.setUser(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
            if (currentSelection instanceof IStructuredSelection) {
                StructuredSelection selection = (StructuredSelection)currentSelection;
                for (Object object : selection) {
                    if (object instanceof IScriptProject) {
                        IScriptProject p = (IScriptProject)object;
                        projects.add(p.getProject());
                        continue;
                    }
                    if (!(object instanceof IProject)) continue;
                    projects.add((IProject)object);
                }
            }
            monitor.beginTask("Converting to UIMA Ruta project...", projects.size());
            for (IProject each : projects) {
                try {
                    IScriptProject scriptProject = DLTKCore.create((IProject)each);
                    ResourceUtil.addNature((IProject)each, (IProgressMonitor)monitor, (String)"org.apache.uima.ruta.ide.nature");
                    RutaProjectCreationWizard.createRutaProject((IScriptProject)scriptProject, null, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    RutaAddonsPlugin.error(e);
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

