/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.kep;

import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerMultiSlotRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerSlotPattern;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.kep.KEPRuleItem;

public class KEPRule
extends TextRulerMultiSlotRule {
    private boolean isCorrectionRule = false;

    public KEPRule(KEPRule copyFrom) {
        super(copyFrom);
        this.isCorrectionRule = copyFrom.isCorrectionRule;
    }

    public KEPRule(TextRulerBasicLearner parentAlgorithm, TextRulerTarget target) {
        super(parentAlgorithm, target);
        this.slotPatterns.add(new TextRulerSlotPattern());
    }

    @Override
    public KEPRule copy() {
        return new KEPRule(this);
    }

    public double getLaplacian() {
        int e = 0;
        int n = 0;
        if (this.coveringStatistics != null) {
            e = this.coveringStatistics.getCoveredNegativesCount();
            n = this.coveringStatistics.getCoveredNegativesCount() + this.coveringStatistics.getCoveredPositivesCount();
        }
        return ((double)e + 1.0) / ((double)n + 1.0);
    }

    public boolean containsTerm(KEPRuleItem term) {
        for (TextRulerSlotPattern sp : this.slotPatterns) {
            for (TextRulerRuleItem i : sp.preFillerPattern) {
                if (!i.equals(term)) continue;
                return true;
            }
            for (TextRulerRuleItem i : sp.fillerPattern) {
                if (!i.equals(term)) continue;
                return true;
            }
            for (TextRulerRuleItem i : sp.postFillerPattern) {
                if (!i.equals(term)) continue;
                return true;
            }
        }
        return false;
    }

    public KEPRuleItem searchNeighborOfItem(KEPRuleItem item, boolean goToLeft) {
        int slotIndex = -1;
        int patternIndex = -1;
        int slotI = 0;
        for (TextRulerSlotPattern sp : this.slotPatterns) {
            for (TextRulerRuleItem it : sp.preFillerPattern) {
                if (it != item) continue;
                slotIndex = slotI;
                patternIndex = 0;
                break;
            }
            if (slotIndex < 0) {
                for (TextRulerRuleItem it : sp.fillerPattern) {
                    if (it != item) continue;
                    slotIndex = slotI;
                    patternIndex = 1;
                    break;
                }
            }
            if (slotIndex < 0) {
                for (TextRulerRuleItem it : sp.postFillerPattern) {
                    if (it != item) continue;
                    slotIndex = slotI;
                    patternIndex = 2;
                    break;
                }
            }
            if (slotIndex < 0) continue;
            break;
        }
        if (slotIndex < 0) {
            return null;
        }
        TextRulerRulePattern currentPattern = this.getPattern(slotIndex, patternIndex);
        while (currentPattern != null) {
            int startSearchFromIndex;
            int startIndex = currentPattern.indexOf(item);
            if (!goToLeft) {
                startSearchFromIndex = startIndex + 1;
                if (startSearchFromIndex < currentPattern.size()) {
                    return (KEPRuleItem)currentPattern.get(startSearchFromIndex);
                }
                if (++patternIndex > 2) {
                    patternIndex = 0;
                    if (++slotIndex >= this.slotPatterns.size()) {
                        return null;
                    }
                }
                currentPattern = this.getPattern(slotIndex, patternIndex);
                continue;
            }
            int n = startSearchFromIndex = startIndex >= 0 ? startIndex - 1 : currentPattern.size() - 1;
            if (startSearchFromIndex >= 0 && currentPattern.size() > 0) {
                return (KEPRuleItem)currentPattern.get(startSearchFromIndex);
            }
            if (--patternIndex < 0) {
                patternIndex = 2;
                if (--slotIndex < 0) {
                    return null;
                }
            }
            currentPattern = this.getPattern(slotIndex, patternIndex);
        }
        return null;
    }

    private TextRulerRulePattern getPattern(int slotIndex, int patternIndex) {
        TextRulerSlotPattern sp = (TextRulerSlotPattern)this.slotPatterns.get(slotIndex);
        if (patternIndex == 0) {
            return sp.preFillerPattern;
        }
        if (patternIndex == 1) {
            return sp.fillerPattern;
        }
        if (patternIndex == 2) {
            return sp.postFillerPattern;
        }
        return null;
    }

    public KEPRule addPostFillerItem(KEPRuleItem item) {
        this.getPostFiller().add(item);
        this.setNeedsCompile(true);
        return this;
    }

    public KEPRule addInFillerItem(KEPRuleItem item) {
        this.getInFiller().add(item);
        this.setNeedsCompile(true);
        return this;
    }

    public KEPRule addPreFillerItem(KEPRuleItem item) {
        this.getPreFiller().add(0, item);
        this.setNeedsCompile(true);
        return this;
    }

    public TextRulerRulePattern getPreFiller() {
        return ((TextRulerSlotPattern)this.slotPatterns.get((int)0)).preFillerPattern;
    }

    public void setPreFiller(TextRulerRulePattern preFiller) {
        ((TextRulerSlotPattern)this.slotPatterns.get((int)0)).preFillerPattern = preFiller;
        this.setNeedsCompile(true);
    }

    public TextRulerRulePattern getInFiller() {
        return ((TextRulerSlotPattern)this.slotPatterns.get((int)0)).fillerPattern;
    }

    public void setInFiller(TextRulerRulePattern inFiller) {
        ((TextRulerSlotPattern)this.slotPatterns.get((int)0)).fillerPattern = inFiller;
        this.setNeedsCompile(true);
    }

    public TextRulerRulePattern getPostFiller() {
        return ((TextRulerSlotPattern)this.slotPatterns.get((int)0)).postFillerPattern;
    }

    public void setPostFiller(TextRulerRulePattern postFiller) {
        ((TextRulerSlotPattern)this.slotPatterns.get((int)0)).postFillerPattern = postFiller;
        this.setNeedsCompile(true);
    }

    public KEPRule setCorrectionRule(boolean isCorrectionRule) {
        this.isCorrectionRule = isCorrectionRule;
        this.setNeedsCompile(true);
        return this;
    }

    public boolean isCorrectionRule() {
        return this.isCorrectionRule;
    }

    @Override
    public TextRulerTarget getTarget() {
        return this.target;
    }

    public void setTarget(TextRulerTarget target) {
        this.target = target;
        this.setNeedsCompile(true);
    }

    public boolean coversSameExamples(KEPRule otherRule) {
        return otherRule.getCoveringStatistics().getCoveredPositivesCount() == this.getCoveringStatistics().getCoveredPositivesCount() && otherRule.getCoveringStatistics().getCoveredPositiveExamples().containsAll(this.getCoveringStatistics().getCoveredPositiveExamples());
    }
}

