/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resourceSpecifier.factory.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.resourceSpecifier.factory.ColocatedDelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.DelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.ErrorHandlingSettings;
import org.apache.uima.resourceSpecifier.factory.impl.DelegateConfigurationImpl;
import org.springframework.util.Assert;

public class ColocatedDelegateConfigurationImpl
extends DelegateConfigurationImpl
implements ColocatedDelegateConfiguration {
    private List<DelegateConfiguration> delegates = new ArrayList<DelegateConfiguration>();
    private int numberOfInstances = 1;
    private int internalReplyQueueScaleout = 1;
    private int inputQueueScaleout = 1;

    public ColocatedDelegateConfigurationImpl(String key, DelegateConfiguration[] nestedDelegateConfiguration, ErrorHandlingSettings ... errorHandlingSettings) {
        super(key, errorHandlingSettings);
        super.setRemote(false);
        for (DelegateConfiguration cdc : nestedDelegateConfiguration) {
            this.addDelegate(cdc);
        }
    }

    @Override
    public void addDelegate(DelegateConfiguration dc) {
        Assert.notNull((Object)dc);
        this.delegates.add(dc);
    }

    @Override
    public List<DelegateConfiguration> getDelegates() {
        return this.delegates;
    }

    @Override
    public boolean isAggregate() {
        return this.delegates.size() > 0;
    }

    @Override
    public void setNumberOfInstances(int numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    @Override
    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    @Override
    public void setInputQueueScaleout(int inputQueueScaleout) {
        this.inputQueueScaleout = inputQueueScaleout;
    }

    @Override
    public int getInputQueueScaleout() {
        return this.inputQueueScaleout;
    }

    @Override
    public void setInternalReplyQueueScaleout(int internalReplyQueueScaleout) {
        this.internalReplyQueueScaleout = internalReplyQueueScaleout;
    }

    @Override
    public int getInternalReplyQueueScaleout() {
        return this.internalReplyQueueScaleout;
    }
}

