/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.util.FileUtil;
import org.apache.uima.pear.util.StringUtil;

public class InstallationProcessor {
    public static final String INSD_FILE_PATH = "metadata/install.xml";
    public static final String VS_DESCRIPTOR_PATH = "desc/vs_desc.xml";
    protected static final String MAIN_ROOT_REGEX = "\\$main_root";
    protected static final String MAIN_ROOT_REL_REGEX = "\\$main_root_rel";
    protected static final String MAIN_ROOT_URL_REGEX = "\\$main_root_url";
    protected static final String DELEGATE_ROOT_PREFIX_REGEX = "\\$";
    protected static final String DELEGATE_ROOT_SUFFIX_REGEX = "\\$root";
    protected static final String DELEGATE_ROOT_REL_SUFFIX_REGEX = "\\$root_rel";
    protected static final String DELEGATE_ROOT_URL_SUFFIX_REGEX = "\\$root_url";
    private static StringBuffer __regexBuffer = new StringBuffer();
    private String _mainRootPath;
    private Hashtable<String, String> _installationTable = new Hashtable();
    private Hashtable<String, String> _urlSubstitutionTable = new Hashtable();
    private Hashtable<String, String> _pathSubstitutionTable = new Hashtable();
    private InstallationDescriptor _insdObject = null;
    private boolean _completed = false;
    private InstallationController _controller = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String componentIdRootRegExp(String componentId, String suffix) {
        StringBuffer stringBuffer = __regexBuffer;
        synchronized (stringBuffer) {
            __regexBuffer.setLength(0);
            __regexBuffer.append(DELEGATE_ROOT_PREFIX_REGEX);
            __regexBuffer.append(componentId);
            __regexBuffer.append(suffix);
            return __regexBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateVSDescriptor(InstallationDescriptor insdObject, File mainRootDir) throws IOException {
        File vsDescriptorFile = new File(mainRootDir, VS_DESCRIPTOR_PATH);
        PrintWriter oWriter = null;
        try {
            oWriter = new PrintWriter(new FileWriter(vsDescriptorFile));
            String xmlContent = InstallationProcessor.generateVSDescriptorContent(insdObject);
            oWriter.println(xmlContent);
            oWriter.close();
        }
        finally {
            if (oWriter != null) {
                try {
                    oWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static InputStream generateVSDescriptorAsStream(InstallationDescriptor insdObject) throws IOException {
        ByteArrayInputStream iStream = null;
        String xmlContent = InstallationProcessor.generateVSDescriptorContent(insdObject);
        byte[] xmlContentBytes = xmlContent.getBytes();
        iStream = new ByteArrayInputStream(xmlContentBytes);
        return iStream;
    }

    protected static String generateVSDescriptorContent(InstallationDescriptor insdObject) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"?>\n");
        buffer.append("<deployment name=\"Vinci ");
        buffer.append(insdObject.getMainComponentName());
        buffer.append(" Service\">\n");
        buffer.append("\t<service name=\"");
        buffer.append(insdObject.getMainComponentId());
        buffer.append("\" host=\"localhost\" provider=\"vinci\">\n");
        buffer.append("\t\t<parameter name=\"resourceSpecifierPath\" ");
        buffer.append("value=\"");
        buffer.append(insdObject.getMainComponentDesc());
        buffer.append("\"/>\n");
        buffer.append("\t\t<parameter name=\"numInstances\" value=\"1\"/>\n");
        buffer.append("\t</service>\n");
        buffer.append("</deployment>");
        return buffer.toString();
    }

    protected static void findAndReplacePath(InstallationDescriptor.ActionInfo action) throws IOException {
        String filePath = action.params.getProperty("FILE");
        if (filePath == null) {
            throw new RuntimeException("no FILE defined");
        }
        String findString = action.params.getProperty("FIND_STRING");
        if (findString == null) {
            throw new RuntimeException("no FIND_STRING defined");
        }
        String replaceWith = action.params.getProperty("REPLACE_WITH");
        if (replaceWith == null) {
            throw new RuntimeException("no REPLACE_WITH defined");
        }
        File inputFile = new File(filePath);
        FileUtil.replaceStringInFile(inputFile, StringUtil.toRegExpString(findString), replaceWith);
    }

    protected static String substituteCompIdRootInString(String source, String compId, String compRootPath) {
        String result = source;
        String regExp = InstallationProcessor.componentIdRootRegExp(compId, DELEGATE_ROOT_URL_SUFFIX_REGEX);
        String fileUrl = FileUtil.localPathToFileUrl(compRootPath);
        String replacement = StringUtil.toRegExpReplacement(fileUrl);
        result = result.replaceAll(regExp, replacement);
        regExp = InstallationProcessor.componentIdRootRegExp(compId, DELEGATE_ROOT_SUFFIX_REGEX);
        replacement = StringUtil.toRegExpReplacement(compRootPath);
        result = result.replaceAll(regExp, replacement);
        return result.trim().replace('\\', '/');
    }

    protected static String substituteMainRootInString(String source, String mainRootPath) {
        String result = source;
        String replacement = StringUtil.toRegExpReplacement(FileUtil.localPathToFileUrl(mainRootPath));
        result = result.replaceAll(MAIN_ROOT_URL_REGEX, replacement);
        replacement = StringUtil.toRegExpReplacement(mainRootPath);
        result = result.replaceAll(MAIN_ROOT_REGEX, replacement);
        return result.trim().replace('\\', '/');
    }

    public InstallationProcessor(String mainRootPath, Hashtable<String, String> installationTable) {
        this(mainRootPath, installationTable, null);
    }

    public InstallationProcessor(String mainRootPath, Hashtable<String, String> installationTable, InstallationController controller) {
        this._controller = controller;
        this._mainRootPath = mainRootPath.replace('\\', '/');
        this._installationTable = installationTable;
        this.initSubstitutionTables(mainRootPath);
    }

    public synchronized InstallationDescriptor getInstallationDescriptor() {
        return this._completed ? this._insdObject : null;
    }

    protected void initSubstitutionTables(String mainRootPath) {
        Enumeration<String> idList = this._installationTable.keys();
        while (idList.hasMoreElements()) {
            String id = idList.nextElement();
            String compIdRootUrlRegEx = InstallationProcessor.componentIdRootRegExp(id, DELEGATE_ROOT_URL_SUFFIX_REGEX);
            String compIdRootRegEx = InstallationProcessor.componentIdRootRegExp(id, DELEGATE_ROOT_SUFFIX_REGEX);
            String rootPath = this._installationTable.get(id);
            String rootPathUrl = FileUtil.localPathToFileUrl(rootPath);
            this._urlSubstitutionTable.put(compIdRootUrlRegEx, rootPathUrl);
            this._pathSubstitutionTable.put(compIdRootRegEx, rootPath);
        }
    }

    public synchronized void process() throws IOException {
        String descDirPath;
        File descDir;
        this._completed = false;
        File mainRootDir = new File(this._mainRootPath);
        File xmlInsDFile = new File(mainRootDir, INSD_FILE_PATH);
        if (this._controller != null) {
            this._controller.getOutMsgWriter().println("[InstallationProcessor]: start processing InsD file - " + xmlInsDFile.getAbsolutePath());
        } else {
            System.out.println("[InstallationProcessor]: start processing InsD file - " + xmlInsDFile.getAbsolutePath());
        }
        InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
        try {
            insdHandler.parse(xmlInsDFile);
        }
        catch (Exception exc) {
            if (exc instanceof IOException) {
                throw (IOException)exc;
            }
            throw new IOException(exc.toString());
        }
        this._insdObject = insdHandler.getInstallationDescriptor();
        this._insdObject.setMainComponentRoot(this._mainRootPath);
        for (InstallationDescriptor.ActionInfo action : this._insdObject.getInstallationActions()) {
            this.substituteStringVariablesInAction(action.params);
            if (!action.getName().equals("find_and_replace_path")) continue;
            InstallationProcessor.findAndReplacePath(action);
        }
        String confDirPath = this._mainRootPath + "/" + "conf";
        File confDir = new File(confDirPath);
        if (confDir.isDirectory()) {
            this.substituteStringVariablesInFiles(confDir);
        }
        if ((descDir = new File(descDirPath = this._mainRootPath + "/" + "desc")).isDirectory()) {
            this.substituteStringVariablesInFiles(descDir);
        }
        this._completed = true;
    }

    protected void substituteStringVariablesInAction(Properties params) {
        Enumeration<?> paramNames = params.propertyNames();
        while (paramNames.hasMoreElements()) {
            String replacement;
            String regex;
            String paramName = (String)paramNames.nextElement();
            String paramValue = params.getProperty(paramName);
            if (paramName.equals("VAR_VALUE")) {
                paramValue = paramValue.replace(';', File.pathSeparatorChar);
            }
            if (!paramName.equals("FILE") && !paramName.equals("REPLACE_WITH") && !paramName.equals("VAR_VALUE")) continue;
            paramValue = InstallationProcessor.substituteMainRootInString(paramValue, this._mainRootPath);
            Enumeration<String> regexList = this._urlSubstitutionTable.keys();
            while (regexList.hasMoreElements()) {
                regex = regexList.nextElement();
                replacement = this._urlSubstitutionTable.get(regex);
                paramValue = paramValue.replaceAll(regex, StringUtil.toRegExpReplacement(replacement));
            }
            regexList = this._pathSubstitutionTable.keys();
            while (regexList.hasMoreElements()) {
                regex = regexList.nextElement();
                replacement = this._pathSubstitutionTable.get(regex);
                paramValue = paramValue.replaceAll(regex, StringUtil.toRegExpReplacement(replacement));
            }
            params.setProperty(paramName, paramValue);
        }
    }

    protected void substituteStringVariablesInFiles(File dir) throws IOException {
        for (File file : FileUtil.createFileList(dir, true)) {
            String regex;
            String replacement = FileUtil.localPathToFileUrl(this._mainRootPath);
            FileUtil.replaceStringInFile(file, MAIN_ROOT_URL_REGEX, replacement);
            replacement = this._mainRootPath;
            FileUtil.replaceStringInFile(file, MAIN_ROOT_REGEX, replacement);
            Enumeration<String> compList = this._installationTable.keys();
            while (compList.hasMoreElements()) {
                String compId = compList.nextElement();
                String compRootPath = this._installationTable.get(compId);
                String regex2 = InstallationProcessor.componentIdRootRegExp(compId, DELEGATE_ROOT_REL_SUFFIX_REGEX);
                try {
                    replacement = FileUtil.computeRelativePath(file.getParentFile(), new File(compRootPath));
                    if (replacement == null) continue;
                    FileUtil.replaceStringInFile(file, regex2, replacement);
                }
                catch (Exception exception) {}
            }
            Enumeration<String> regexList = this._urlSubstitutionTable.keys();
            while (regexList.hasMoreElements()) {
                regex = regexList.nextElement();
                replacement = this._urlSubstitutionTable.get(regex);
                FileUtil.replaceStringInFile(file, regex, replacement);
            }
            regexList = this._pathSubstitutionTable.keys();
            while (regexList.hasMoreElements()) {
                regex = regexList.nextElement();
                replacement = this._pathSubstitutionTable.get(regex);
                FileUtil.replaceStringInFile(file, regex, replacement);
            }
        }
    }
}

