/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.cvd.FSTreeModel;
import org.apache.uima.tools.cvd.FSTreeNode;

public class FSNode
extends FSTreeNode {
    private static final int maxStringLength = 100;
    private final FSTreeModel fSTreeModel;
    static final int INT_FS = 0;
    static final int FLOAT_FS = 1;
    static final int STRING_FS = 2;
    static final int ARRAY_FS = 3;
    static final int STD_FS = 4;
    static final int DISPLAY_NODE = 5;
    static final int BYTE_FS = 6;
    static final int BOOL_FS = 7;
    static final int SHORT_FS = 8;
    static final int LONG_FS = 9;
    static final int DOUBLE_FS = 10;
    private final int nodeClass;
    private final long intOrLongLikeValue;
    private final TOP fs;
    private final String string;
    private final Feature feat;
    private final int arrayElemIdx;
    private final boolean isArrayElem;
    private boolean isShortenedString = false;

    private int k2nc(SlotKinds.SlotKind kind) {
        switch (kind) {
            case Slot_Boolean: 
            case Slot_BooleanRef: {
                return 7;
            }
            case Slot_Byte: 
            case Slot_ByteRef: {
                return 6;
            }
            case Slot_Short: 
            case Slot_ShortRef: {
                return 8;
            }
            case Slot_Int: {
                return 0;
            }
            case Slot_Float: {
                return 1;
            }
            case Slot_LongRef: {
                return 9;
            }
            case Slot_DoubleRef: {
                return 10;
            }
            case Slot_StrRef: {
                return 2;
            }
            case Slot_HeapRef: {
                return 4;
            }
        }
        Misc.internalError();
        return -1;
    }

    FSNode(FSTreeModel fSTreeModel, int nodeClass, Object fsOrString, long intOrLongLikeValue, Feature feat) {
        this.fSTreeModel = fSTreeModel;
        this.nodeClass = nodeClass;
        this.intOrLongLikeValue = intOrLongLikeValue;
        this.fs = fsOrString instanceof TOP ? (TOP)fsOrString : null;
        this.string = fsOrString instanceof String ? (String)fsOrString : null;
        this.feat = feat;
        this.arrayElemIdx = 0;
        this.isArrayElem = false;
    }

    FSNode(FSTreeModel fSTreeModel, int nodeClass, Object fsOrString, long intOrLongLikeValue, int elementIndex) {
        this.fSTreeModel = fSTreeModel;
        this.nodeClass = nodeClass;
        this.intOrLongLikeValue = intOrLongLikeValue;
        this.fs = fsOrString instanceof TOP ? (TOP)fsOrString : null;
        this.string = fsOrString instanceof String ? (String)fsOrString : null;
        this.feat = null;
        this.arrayElemIdx = elementIndex;
        this.isArrayElem = true;
    }

    int getNodeClass() {
        return this.nodeClass;
    }

    @Override
    protected void initChildren() {
        if (this.children != null) {
            return;
        }
        if (this.nodeClass != 4 && this.nodeClass != 3) {
            return;
        }
        if (this.fs == null) {
            return;
        }
        TypeImpl type = this.getType();
        if (type.isArray()) {
            int arrayLength = ((CommonArrayFS)this.fs).size();
            ArrayList<FSNode> arrayNodes = new ArrayList<FSNode>(arrayLength);
            SlotKinds.SlotKind kind = type.getComponentSlotKind();
            int nc = this.k2nc(kind);
            switch (kind) {
                case Slot_Int: {
                    int[] a = ((IntegerArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, null, (long)a[i], i));
                    break;
                }
                case Slot_Float: {
                    float[] a = ((FloatArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, null, (long)CASImpl.float2int((float)a[i]), i));
                    break;
                }
                case Slot_StrRef: {
                    String[] a = ((StringArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, (Object)a[i], 0L, i));
                    break;
                }
                case Slot_HeapRef: {
                    TOP[] a = ((FSArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, (Object)a[i], 0L, i));
                    break;
                }
                case Slot_BooleanRef: {
                    boolean[] a = ((BooleanArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, null, a[i] ? 1L : 0L, i));
                    break;
                }
                case Slot_ByteRef: {
                    byte[] a = ((ByteArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, null, (long)a[i], i));
                    break;
                }
                case Slot_ShortRef: {
                    short[] a = ((ShortArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, null, (long)a[i], i));
                    break;
                }
                case Slot_LongRef: {
                    long[] a = ((LongArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, null, a[i], i));
                    break;
                }
                case Slot_DoubleRef: {
                    double[] a = ((DoubleArray)this.fs)._getTheArray();
                    this.makeNodes(arrayNodes, arrayLength, i -> new FSNode(this.fSTreeModel, nc, null, CASImpl.double2long((double)a[i]), i));
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
            this.children = FSTreeModel.createArrayChildren(0, arrayLength, arrayNodes, this.fSTreeModel);
        } else {
            FeatureImpl[] feats;
            this.children = new ArrayList(type.getNumberOfFeatures());
            block22: for (FeatureImpl f : feats = type.getFeatureImpls()) {
                SlotKinds.SlotKind kind = f.getSlotKind();
                int nc = this.k2nc(kind);
                switch (kind) {
                    case Slot_Boolean: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, null, this.fs.getBooleanValue((Feature)f) ? 1L : 0L, (Feature)f));
                        continue block22;
                    }
                    case Slot_Byte: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, null, (long)this.fs.getByteValue((Feature)f), (Feature)f));
                        continue block22;
                    }
                    case Slot_Short: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, null, (long)this.fs.getShortValue((Feature)f), (Feature)f));
                        continue block22;
                    }
                    case Slot_Int: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, null, (long)this.fs.getIntValue((Feature)f), (Feature)f));
                        continue block22;
                    }
                    case Slot_Float: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, null, (long)CASImpl.float2int((float)this.fs.getFloatValue((Feature)f)), (Feature)f));
                        continue block22;
                    }
                    case Slot_LongRef: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, null, this.fs.getLongValue((Feature)f), (Feature)f));
                        continue block22;
                    }
                    case Slot_DoubleRef: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, null, CASImpl.double2long((double)this.fs.getDoubleValue((Feature)f)), (Feature)f));
                        continue block22;
                    }
                    case Slot_StrRef: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, (Object)this.fs.getStringValue((Feature)f), 0L, (Feature)f));
                        continue block22;
                    }
                    case Slot_HeapRef: {
                        this.children.add(new FSNode(this.fSTreeModel, nc, (Object)this.fs.getFeatureValue((Feature)f), 0L, (Feature)f));
                        continue block22;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
            }
        }
    }

    private void makeNodes(List<FSNode> arrayNodes, int size, IntFunction<FSNode> newFSNode) {
        for (int idx = 0; idx < size; ++idx) {
            arrayNodes.add(newFSNode.apply(idx));
        }
    }

    public String toString() {
        if (this.nodeClass == 5) {
            return this.fSTreeModel.getRootString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        if (this.isArrayElem) {
            buf.append('[');
            buf.append(this.arrayElemIdx);
            buf.append("] = ");
        } else if (this.feat != null) {
            buf.append(this.getFeatureString());
            buf.append(" = ");
        }
        buf.append(this.getValueString());
        buf.append("</html>");
        return buf.toString();
    }

    private String getFeatureString() {
        return "<i>" + this.feat.getShortName() + "</i>";
    }

    boolean isShortenedString() {
        return this.isShortenedString;
    }

    String getFullString() {
        if (this.getNodeClass() != 2) {
            return null;
        }
        return this.string;
    }

    private String getValueString() {
        switch (this.nodeClass) {
            case 0: 
            case 6: 
            case 8: {
                return Long.toString(this.intOrLongLikeValue);
            }
            case 1: {
                return Float.toString(CASImpl.int2float((int)((int)this.intOrLongLikeValue)));
            }
            case 7: {
                return 0L == this.intOrLongLikeValue ? "false" : "true";
            }
            case 9: {
                return Long.toString(this.intOrLongLikeValue);
            }
            case 10: {
                return Double.toString(CASImpl.long2double((long)this.intOrLongLikeValue));
            }
            case 2: {
                if (this.string == null) {
                    return this.getNullString();
                }
                String s = this.string;
                String s1 = FSNode.shortenString(s);
                this.isShortenedString = s != s1;
                return "\"" + FSNode.escapeLt(s1) + "\"";
            }
            case 3: {
                if (this.fs == null) {
                    return this.getNullString();
                }
                return "<font color=blue>" + this.getType().getName() + "</font>[" + ((CommonArrayFS)this.fs).size() + "]";
            }
            case 4: {
                if (this.fs == null) {
                    return this.getNullString();
                }
                return "<font color=blue>" + this.getType().getName() + "</font>";
            }
        }
        return null;
    }

    private static final String shortenString(String s) {
        if (s.length() <= 100) {
            return s;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(s.substring(0, 100));
        buf.append("...");
        return buf.toString();
    }

    private static final String escapeLt(String s) {
        int i;
        int max = s.length();
        for (i = 0; i < max && s.charAt(i) != '<'; ++i) {
        }
        if (i == max) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.substring(0, i));
        while (i < max) {
            if (s.charAt(i) == '<') {
                buf.append("&lt;");
            } else {
                buf.append(s.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    private String getNullString() {
        return "&lt;null&gt;";
    }

    int getArrayPos() {
        return this.arrayElemIdx;
    }

    TypeImpl getType() {
        return this.fs._getTypeImpl();
    }

    public boolean isAnnotation() {
        return this.fs != null && this.fs instanceof Annotation;
    }

    public int getStart() {
        return this.isAnnotation() ? ((Annotation)this.fs).getBegin() : -1;
    }

    public int getEnd() {
        return this.isAnnotation() ? ((Annotation)this.fs).getEnd() : -1;
    }
}

