/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.uima.internal.util.IntBitSet;
import org.apache.uima.internal.util.IntHashSet;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntSet;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.util.impl.Constants;

public class PositiveIntSet_impl
implements PositiveIntSet {
    private static final int HYSTERESIS = 16;
    private static final int INT_SET_MAX_SIZE = 16;
    private static final int HASH_SET_SHORT_MAX_SIZE = 65535;
    private static final int BIT_SET_OVERALLOCATE = 256;
    private static final int HASH_SET_OVERALLOCATE_DIVIDER_SHIFT = 1;
    private PositiveIntSet intSet;
    boolean isBitSet = false;
    boolean isIntSet = false;
    boolean isHashSet = false;
    boolean secondTimeShrinkable = false;
    boolean useOffset = true;

    public PositiveIntSet_impl() {
        this(0, 0, 0);
    }

    public PositiveIntSet_impl(int initialSize, int estMin, int estMax) {
        int hashSetWordsNeeded;
        if (initialSize == 0) {
            this.isBitSet = true;
            return;
        }
        if (initialSize < 0 || estMin < 0 || estMax < estMin) {
            throw new IllegalArgumentException();
        }
        estMax = Math.max(initialSize, estMax);
        int offsetBitSet = PositiveIntSet_impl.estimatedBitSetOffset(estMin, -1);
        int offsetHashSet = PositiveIntSet_impl.getHashSetOffset(estMax, estMin);
        int bitSetWordsNeeded = PositiveIntSet_impl.getBitSetSpaceFromRange(estMax - offsetBitSet, 0);
        if (bitSetWordsNeeded < (hashSetWordsNeeded = PositiveIntSet_impl.getHashSetSpace(initialSize, estMax, estMin))) {
            this.allocateIntBitSet(estMax, estMin, offsetBitSet);
            this.isBitSet = true;
            return;
        }
        if (initialSize <= 16) {
            this.intSet = new IntSet(initialSize);
            this.isIntSet = true;
            return;
        }
        this.intSet = new IntHashSet(initialSize, offsetHashSet);
        this.isHashSet = true;
    }

    @Override
    public IntListIterator iterator() {
        return this.getUnorderedIterator();
    }

    public IntListIterator getUnorderedIterator() {
        if (null == this.intSet) {
            this.intSet = new IntSet(0);
        }
        return this.intSet.iterator();
    }

    public IntListIterator getOrderedIterator() {
        if (this.isBitSet) {
            if (null == this.intSet) {
                return new IntListIteratorOverArray(Constants.EMPTY_INT_ARRAY);
            }
            return this.intSet.iterator();
        }
        int[] allValues = new int[this.size()];
        IntListIterator it = this.intSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            allValues[i++] = it.nextNvc();
        }
        Arrays.sort(allValues);
        return new IntListIteratorOverArray(allValues);
    }

    @Override
    public void clear() {
        if (null != this.intSet) {
            if (this.isBitSet) {
                if (this.secondTimeShrinkable) {
                    this.secondTimeShrinkable = false;
                    IntBitSet ib = (IntBitSet)this.intSet;
                    int max = ib.getLargestMenber();
                    int offset = ib.getOffset();
                    this.intSet = new IntBitSet(max - offset >> 1, offset);
                } else {
                    this.intSet.clear();
                    this.secondTimeShrinkable = true;
                }
            } else {
                this.intSet.clear();
            }
        }
    }

    @Override
    public boolean contains(int key) {
        return null != this.intSet ? this.intSet.contains(key) : false;
    }

    @Override
    public int find(int element) {
        return null != this.intSet ? this.intSet.find(element) : -1;
    }

    @Override
    public boolean add(int key) {
        this.maybeSwitchRepresentation(key);
        return this.intSet.add(key);
    }

    @Override
    public boolean remove(int key) {
        return null != this.intSet ? this.intSet.remove(key) : false;
    }

    @Override
    public int size() {
        return null != this.intSet ? this.intSet.size() : 0;
    }

    private void adjustBitSetForLowerOffset(int key) {
        IntBitSet intBitSet = (IntBitSet)this.intSet;
        int size = intBitSet.size() + 1;
        int largestInt = intBitSet.getLargestMenber();
        int bitSetSpaceNeeded = PositiveIntSet_impl.getBitSetSpaceFromRange(largestInt, 0);
        int hashSetSpaceNeeded = PositiveIntSet_impl.getHashSetSpace(size, largestInt, key);
        this.useOffset = false;
        if (hashSetSpaceNeeded < bitSetSpaceNeeded - 16) {
            int offset = PositiveIntSet_impl.getHashSetOffset(largestInt, key);
            this.switchFromBitSet(size, offset);
        } else {
            IntListIterator it = this.intSet.iterator();
            this.allocateIntBitSet(largestInt, key, 0);
            while (it.hasNext()) {
                this.intSet.add(it.nextNvc());
            }
        }
    }

    private static int getHashSetOffset(int estMax, int estMin) {
        int range = estMax - estMin;
        assert (range >= 0);
        return range > 65535 ? Integer.MIN_VALUE : estMax - (range >> 2);
    }

    public int[] toUnorderedIntArray() {
        int[] a = new int[this.size()];
        IntListIterator it = this.getUnorderedIterator();
        int i = 0;
        while (it.hasNext()) {
            a[i++] = it.nextNvc();
        }
        return a;
    }

    public int[] toOrderedIntArray() {
        int[] a = this.toUnorderedIntArray();
        if (this.isBitSet) {
            return a;
        }
        Arrays.sort(a);
        return a;
    }

    private static int getBitSetSpaceFromRange(int adjKey, int spaceUsed) {
        int w64 = 1 + (adjKey >> 6);
        int newSpace = Math.max(spaceUsed >>= 5, w64) << 1;
        return newSpace + 2;
    }

    private static int getIntSetSpace(int size) {
        return size < 16 ? size + 4 : Integer.MAX_VALUE;
    }

    private int getHashSetSpace() {
        return ((IntHashSet)this.intSet).getSpaceUsedInWords() * 2 + IntHashSet.getSpaceOverheadInWords();
    }

    private static int getHashSetSpace(int numberOfElements, int estMax, int estMin) {
        boolean isShort = numberOfElements > 65535 ? false : estMax - estMin < 65535;
        int numberOfTableElements = IntHashSet.tableSpace(numberOfElements);
        return (numberOfTableElements >> (isShort ? 1 : 0)) + IntHashSet.getSpaceOverheadInWords();
    }

    private static int getHashSetOverAllocateSize(int existingSize) {
        return existingSize + (existingSize >> 1);
    }

    private void maybeSwitchRepresentation(int newKey) {
        if (this.isBitSet) {
            this.handleBitSet(newKey);
            return;
        }
        if (this.isIntSet) {
            this.handleIntSet(newKey);
            return;
        }
        this.handleHashSet(newKey);
    }

    private void handleBitSet(int newKey) {
        int offset;
        IntBitSet intBitSet = (IntBitSet)this.intSet;
        if (intBitSet == null) {
            boolean guaranteedFits = this.allocateIntBitSet(newKey, newKey, -1);
            intBitSet = (IntBitSet)this.intSet;
            if (guaranteedFits) {
                return;
            }
        }
        if (newKey < (offset = intBitSet.getOffset())) {
            this.adjustBitSetForLowerOffset(newKey);
            return;
        }
        int adjKey = newKey - offset;
        int spaceUsed = intBitSet.getSpaceUsed_in_bits_no_overhead();
        if (adjKey < spaceUsed) {
            return;
        }
        int bitSetSpaceNeeded = PositiveIntSet_impl.getBitSetSpaceFromRange(adjKey, spaceUsed);
        int sizeNeeded = intBitSet.size() + 1;
        if (PositiveIntSet_impl.getIntSetSpace(sizeNeeded) < bitSetSpaceNeeded) {
            this.switchToIntSet(sizeNeeded);
            return;
        }
        int hashSetOverAllocateSize = PositiveIntSet_impl.getHashSetOverAllocateSize(sizeNeeded);
        int hashSetOverAllocateSpace = PositiveIntSet_impl.getHashSetSpace(hashSetOverAllocateSize, newKey, offset);
        if (hashSetOverAllocateSpace < bitSetSpaceNeeded - 16) {
            this.switchToHashSet(hashSetOverAllocateSize, PositiveIntSet_impl.getHashSetOffset(newKey, offset));
        }
    }

    private void handleIntSet(int newKey) {
        int hashSetOverAllocSize;
        int hashSetSpace;
        int bitSetSpace;
        IntSet is = (IntSet)this.intSet;
        int size = is.size() + 1;
        if (size <= 16) {
            return;
        }
        int mostPos = Integer.MIN_VALUE;
        int mostNeg = Integer.MAX_VALUE;
        for (int i = 0; i < size - 1; ++i) {
            int v = is.get(i);
            if (v > mostPos) {
                mostPos = v;
            }
            if (v >= mostNeg) continue;
            mostNeg = v;
        }
        if (newKey > mostPos) {
            mostPos = newKey;
        }
        if (newKey < mostNeg) {
            mostNeg = newKey;
        }
        if ((bitSetSpace = PositiveIntSet_impl.getBitSetSpaceFromRange(mostPos - mostNeg, 0)) < (hashSetSpace = PositiveIntSet_impl.getHashSetSpace(hashSetOverAllocSize = PositiveIntSet_impl.getHashSetOverAllocateSize(size), mostPos, mostNeg))) {
            this.switchToBitSet(mostPos, mostNeg, PositiveIntSet_impl.estimatedBitSetOffset(mostNeg, -1));
            return;
        }
        this.switchToHashSet(hashSetOverAllocSize, PositiveIntSet_impl.getHashSetOffset(mostPos, mostNeg));
    }

    private void handleHashSet(int newKey) {
        int offset;
        IntHashSet intHashSet = (IntHashSet)this.intSet;
        if (intHashSet.wontExpand()) {
            return;
        }
        int hashSetSpaceNeeded = this.getHashSetSpace();
        int maxInt = intHashSet.getMostPositive();
        int bitSetSpaceNeeded = PositiveIntSet_impl.getBitSetSpaceFromRange(256 + maxInt - (offset = this.useOffset ? Math.min(intHashSet.getMostNegative(), newKey) : 0), 0);
        if (bitSetSpaceNeeded < hashSetSpaceNeeded - 16) {
            this.switchToBitSet(maxInt, intHashSet.getMostNegative(), offset);
        }
    }

    private boolean allocateIntBitSet(int estMax, int estMin, int offsetSpec) {
        this.isBitSet = true;
        this.isIntSet = false;
        this.isHashSet = false;
        if (this.useOffset) {
            int offset = PositiveIntSet_impl.estimatedBitSetOffset(estMin, offsetSpec);
            this.intSet = new IntBitSet(256 + estMax - offset, offset);
            return true;
        }
        this.intSet = new IntBitSet(256 + estMax);
        return false;
    }

    private static int estimatedBitSetOffset(int estMin, int offsetSpec) {
        return offsetSpec == -1 ? Math.max(0, estMin - Math.min(1023, Math.max(63, estMin >> 3))) : offsetSpec;
    }

    private void switchFromBitSet(int size, int offset) {
        if (size < 16) {
            this.switchToIntSet(size);
            return;
        }
        this.switchToHashSet(size, offset);
    }

    private void switchToIntSet(int size) {
        IntListIterator it = this.intSet.iterator();
        this.intSet = new IntSet(size);
        this.isIntSet = true;
        this.isHashSet = false;
        this.isBitSet = false;
        while (it.hasNext()) {
            this.intSet.add(it.nextNvc());
        }
    }

    private void switchToHashSet(int size, int offset) {
        IntListIterator it = this.intSet.iterator();
        this.intSet = new IntHashSet(size, offset);
        this.isBitSet = false;
        this.isIntSet = false;
        this.isHashSet = true;
        while (it.hasNext()) {
            this.intSet.add(it.nextNvc());
        }
    }

    private void switchToBitSet(int estMax, int estMin, int offset) {
        IntListIterator it = this.intSet.iterator();
        this.allocateIntBitSet(estMax, estMin, offset);
        while (it.hasNext()) {
            this.intSet.add(it.nextNvc());
        }
    }

    @Override
    public int get(int position) {
        if (null == this.intSet) {
            throw new NoSuchElementException();
        }
        return this.intSet.get(position);
    }

    @Override
    public int moveToFirst() {
        return null == this.intSet ? -1 : this.intSet.moveToFirst();
    }

    @Override
    public int moveToLast() {
        return null == this.intSet ? -1 : this.intSet.moveToLast();
    }

    @Override
    public int moveToNext(int position) {
        return null == this.intSet ? -1 : this.intSet.moveToNext(position);
    }

    @Override
    public int moveToPrevious(int position) {
        return null == this.intSet ? -1 : this.intSet.moveToPrevious(position);
    }

    @Override
    public boolean isValid(int position) {
        return null == this.intSet ? false : this.intSet.isValid(position);
    }

    @Override
    public void bulkAddTo(IntVector v) {
        if (null != this.intSet) {
            this.intSet.bulkAddTo(v);
        }
    }

    @Override
    public int[] toIntArray() {
        if (null != this.intSet) {
            return this.intSet.toIntArray();
        }
        return Constants.EMPTY_INT_ARRAY;
    }

    public String toString() {
        return String.format("PositiveIntSet_impl [%n  intSet=%s%n secondTimeShrinkable=%s, useOffset=%s]", this.intSet, this.secondTimeShrinkable, this.useOffset);
    }

    boolean isOffsetBitSet() {
        return this.isBitSet && ((IntBitSet)this.intSet).getOffset() != 0;
    }

    boolean isShortHashSet() {
        return this.isHashSet && ((IntHashSet)this.intSet).isShortHashSet();
    }

    private class IntListIteratorOverArray
    implements IntListIterator {
        private int[] a;
        private int pos;

        IntListIteratorOverArray(int[] a) {
            this.a = a;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0 && this.pos < this.a.length;
        }

        @Override
        public int nextNvc() {
            return this.a[this.pos++];
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0 && this.pos < this.a.length;
        }

        @Override
        public int previousNvc() {
            return this.a[--this.pos];
        }

        @Override
        public void moveToStart() {
            this.pos = 0;
        }

        @Override
        public void moveToEnd() {
            this.pos = this.a.length - 1;
        }
    }
}

