/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.rest.action.document.RestDeleteAction;

public class RestIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestDeleteAction.class));
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in document index requests is deprecated, use the typeless endpoints instead (/{index}/_doc/{id}, /{index}/_doc, or /{index}/_create/{id}).";

    public RestIndexAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_doc", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_doc/{id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_doc/{id}", this);
        CreateHandler createHandler = new CreateHandler();
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_create/{id}", createHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_create/{id}/", createHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/{id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/{id}/_create", createHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_create", createHandler);
    }

    @Override
    public String getName() {
        return "document_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        IndexRequest indexRequest;
        String type = request.param("type");
        if (type != null && !type.equals("_doc")) {
            deprecationLogger.deprecatedAndMaybeLog("index_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            indexRequest = new IndexRequest(request.param("index"), type, request.param("id"));
        } else {
            indexRequest = new IndexRequest(request.param("index"));
            indexRequest.id(request.param("id"));
        }
        indexRequest.routing(request.param("routing"));
        indexRequest.setPipeline(request.param("pipeline"));
        indexRequest.source(request.requiredContent(), request.getXContentType());
        indexRequest.timeout(request.paramAsTime("timeout", IndexRequest.DEFAULT_TIMEOUT));
        indexRequest.setRefreshPolicy(request.param("refresh"));
        indexRequest.version(RestActions.parseVersion(request));
        indexRequest.versionType(VersionType.fromString(request.param("version_type"), indexRequest.versionType()));
        indexRequest.setIfSeqNo(request.paramAsLong("if_seq_no", indexRequest.ifSeqNo()));
        indexRequest.setIfPrimaryTerm(request.paramAsLong("if_primary_term", indexRequest.ifPrimaryTerm()));
        String sOpType = request.param("op_type");
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            indexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        if (sOpType != null) {
            indexRequest.opType(sOpType);
        }
        return channel -> client.index(indexRequest, new RestStatusToXContentListener<IndexResponse>((RestChannel)channel, r -> r.getLocation(indexRequest.routing())));
    }

    final class CreateHandler
    extends BaseRestHandler {
        protected CreateHandler() {
        }

        @Override
        public String getName() {
            return "document_create_action";
        }

        @Override
        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            this.validateOpType(request.params().get("op_type"));
            request.params().put("op_type", "create");
            return RestIndexAction.this.prepareRequest(request, client);
        }

        void validateOpType(String opType) {
            if (null != opType && !"create".equals(opType.toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("opType must be 'create', found: [" + opType + "]");
            }
        }
    }
}

