/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchCountDownCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchGetCountCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchTrySetCountCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.ICountDownLatch;
import java.util.concurrent.TimeUnit;

public class ClientCountDownLatchProxy
extends PartitionSpecificClientProxy
implements ICountDownLatch {
    public ClientCountDownLatchProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = CountDownLatchAwaitCodec.encodeRequest(this.name, this.getTimeInMillis(timeout, unit));
        CountDownLatchAwaitCodec.ResponseParameters resultParameters = CountDownLatchAwaitCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public void countDown() {
        ClientMessage request = CountDownLatchCountDownCodec.encodeRequest(this.name);
        this.invokeOnPartition(request);
    }

    @Override
    public int getCount() {
        ClientMessage request = CountDownLatchGetCountCodec.encodeRequest(this.name);
        CountDownLatchGetCountCodec.ResponseParameters resultParameters = CountDownLatchGetCountCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public boolean trySetCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count can't be negative");
        }
        ClientMessage request = CountDownLatchTrySetCountCodec.encodeRequest(this.name, count);
        CountDownLatchTrySetCountCodec.ResponseParameters resultParameters = CountDownLatchTrySetCountCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    public String toString() {
        return "ICountDownLatch{name='" + this.name + '\'' + '}';
    }
}

