/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.processor;

import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.router.api.ImportConfiguration;
import org.apache.unomi.router.api.ProfileToImport;
import org.apache.unomi.router.api.RouterUtils;
import org.apache.unomi.router.api.exceptions.BadProfileDataFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineSplitProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger((String)LineSplitProcessor.class.getName());
    private Map<String, Integer> fieldsMapping;
    private List<String> propertiesToOverwrite;
    private String mergingProperty;
    private boolean overwriteExistingProfiles;
    private boolean hasHeader;
    private boolean hasDeleteColumn;
    private String columnSeparator;
    private String multiValueSeparator;
    private String multiValueDelimiter;
    private Collection<PropertyType> profilePropertyTypes;

    public void process(Exchange exchange) throws Exception {
        ImportConfiguration importConfigOneShot = (ImportConfiguration)exchange.getIn().getHeader("importConfigOneShot");
        String configType = (String)exchange.getIn().getHeader("configType");
        if (importConfigOneShot != null) {
            this.fieldsMapping = (Map)importConfigOneShot.getProperties().get("mapping");
            this.propertiesToOverwrite = importConfigOneShot.getPropertiesToOverwrite();
            this.mergingProperty = importConfigOneShot.getMergingProperty();
            this.overwriteExistingProfiles = importConfigOneShot.isOverwriteExistingProfiles();
            this.columnSeparator = importConfigOneShot.getColumnSeparator();
            this.hasHeader = importConfigOneShot.isHasHeader();
            this.hasDeleteColumn = importConfigOneShot.isHasDeleteColumn();
            this.multiValueSeparator = importConfigOneShot.getMultiValueSeparator();
            this.multiValueDelimiter = importConfigOneShot.getMultiValueDelimiter();
        }
        if ((Integer)exchange.getProperty("CamelSplitIndex") == 0 && this.hasHeader) {
            exchange.setProperty("CamelRouteStop", (Object)Boolean.TRUE);
            return;
        }
        RFC4180Parser rfc4180Parser = new RFC4180ParserBuilder().withSeparator(this.columnSeparator.charAt(0)).build();
        logger.debug("$$$$ : LineSplitProcessor : BODY : " + (String)exchange.getIn().getBody());
        String[] profileData = rfc4180Parser.parseLine((String)exchange.getIn().getBody());
        ProfileToImport profileToImport = new ProfileToImport();
        profileToImport.setItemId(UUID.randomUUID().toString());
        profileToImport.setItemType("profile");
        profileToImport.setScope("integration");
        if (profileData.length > 0 && StringUtils.isNotBlank((CharSequence)profileData[0])) {
            if (this.hasDeleteColumn && this.fieldsMapping.size() > profileData.length - 1 || !this.hasDeleteColumn && this.fieldsMapping.size() > profileData.length) {
                throw new BadProfileDataFormatException("The mapping does not match the number of column : line [" + ((Integer)exchange.getProperty("CamelSplitIndex") + 1) + "]", new Throwable("MAPPING_COLUMN_MATCH"));
            }
            logger.debug("$$$$ : LineSplitProcessor : MAPPING : " + this.fieldsMapping.keySet());
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (String fieldMappingKey : this.fieldsMapping.keySet()) {
                PropertyType propertyType = RouterUtils.getPropertyTypeById(this.profilePropertyTypes, (String)fieldMappingKey);
                if (fieldMappingKey != null && this.fieldsMapping.get(fieldMappingKey) != null && profileData != null && profileData[this.fieldsMapping.get(fieldMappingKey)] != null) {
                    logger.debug("$$$$ : LineSplitProcessor : PropType value : {}", (Object)profileData[this.fieldsMapping.get(fieldMappingKey)].trim());
                } else {
                    logger.debug("$$$$ : LineSplitProcessor : no profileData found for fieldMappingKey=" + fieldMappingKey);
                }
                if (profileData.length <= this.fieldsMapping.get(fieldMappingKey)) continue;
                try {
                    if (propertyType == null) {
                        logger.error("No valid property type found for propertyTypeId=" + fieldMappingKey);
                    } else if (propertyType.getValueTypeId() == null) {
                        logger.error("No value type id found for property type " + propertyType.getItemId());
                    }
                    if (propertyType.getValueTypeId().equals("string") || propertyType.getValueTypeId().equals("email") || propertyType.getValueTypeId().equals("date")) {
                        if (BooleanUtils.isTrue((Boolean)propertyType.isMultivalued())) {
                            String multivalueArray = profileData[this.fieldsMapping.get(fieldMappingKey)].trim();
                            if (StringUtils.isNotBlank((CharSequence)this.multiValueDelimiter) && this.multiValueDelimiter.length() == 2) {
                                multivalueArray = multivalueArray.replaceAll("\\" + this.multiValueDelimiter.charAt(0), "").replaceAll("\\" + this.multiValueDelimiter.charAt(1), "");
                            }
                            if (multivalueArray.contains(this.multiValueSeparator)) {
                                String[] valuesArray = multivalueArray.split("\\" + this.multiValueSeparator);
                                properties.put(fieldMappingKey, valuesArray);
                                continue;
                            }
                            if (StringUtils.isNotBlank((CharSequence)multivalueArray)) {
                                properties.put(fieldMappingKey, new String[]{multivalueArray});
                                continue;
                            }
                            properties.put(fieldMappingKey, new String[0]);
                            continue;
                        }
                        String singleValue = profileData[this.fieldsMapping.get(fieldMappingKey)].trim();
                        properties.put(fieldMappingKey, singleValue);
                        continue;
                    }
                    if (propertyType.getValueTypeId().equals("boolean")) {
                        properties.put(fieldMappingKey, new Boolean(profileData[this.fieldsMapping.get(fieldMappingKey)].trim()));
                        continue;
                    }
                    if (propertyType.getValueTypeId().equals("integer")) {
                        properties.put(fieldMappingKey, new Integer(profileData[this.fieldsMapping.get(fieldMappingKey)].trim()));
                        continue;
                    }
                    if (!propertyType.getValueTypeId().equals("long")) continue;
                    properties.put(fieldMappingKey, new Long(profileData[this.fieldsMapping.get(fieldMappingKey)].trim()));
                }
                catch (Throwable t) {
                    logger.error("Error converting profileData", t);
                    if (fieldMappingKey != null && this.fieldsMapping.get(fieldMappingKey) != null && profileData != null && profileData[this.fieldsMapping.get(fieldMappingKey)] != null) {
                        throw new BadProfileDataFormatException("Unable to convert '" + profileData[this.fieldsMapping.get(fieldMappingKey)].trim() + "' to " + propertyType != null ? propertyType.getValueTypeId() : "Null propertyType ", new Throwable("DATA_TYPE"));
                    }
                    throw new BadProfileDataFormatException("Unable to find profile data for key " + fieldMappingKey, new Throwable("DATA_TYPE"));
                }
            }
            profileToImport.setProperties(properties);
            profileToImport.setMergingProperty(this.mergingProperty);
            profileToImport.setPropertiesToOverwrite(this.propertiesToOverwrite);
            profileToImport.setOverwriteExistingProfiles(this.overwriteExistingProfiles);
            if (this.hasDeleteColumn && StringUtils.isNotBlank((CharSequence)profileData[profileData.length - 1]) && Boolean.parseBoolean(profileData[profileData.length - 1].trim())) {
                profileToImport.setProfileToDelete(true);
            }
        } else {
            throw new BadProfileDataFormatException("Empty line : line [" + ((Integer)exchange.getProperty("CamelSplitIndex") + 1) + "]", new Throwable("EMPTY_LINE"));
        }
        exchange.getIn().setBody((Object)profileToImport, ProfileToImport.class);
        if ("kafka".equals(configType)) {
            exchange.getIn().setHeader("kafka.PARTITION_KEY", (Object)0);
            exchange.getIn().setHeader("kafka.KEY", (Object)"1");
        }
    }

    public void setFieldsMapping(Map<String, Integer> fieldsMapping) {
        this.fieldsMapping = fieldsMapping;
    }

    public void setPropertiesToOverwrite(List<String> propertiesToOverwrite) {
        this.propertiesToOverwrite = propertiesToOverwrite;
    }

    public void setOverwriteExistingProfiles(boolean overwriteExistingProfiles) {
        this.overwriteExistingProfiles = overwriteExistingProfiles;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public void setHasDeleteColumn(boolean hasDeleteColumn) {
        this.hasDeleteColumn = hasDeleteColumn;
    }

    public void setMergingProperty(String mergingProperty) {
        this.mergingProperty = mergingProperty;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setMultiValueSeparator(String multiValueSeparator) {
        this.multiValueSeparator = multiValueSeparator;
    }

    public void setMultiValueDelimiter(String multiValueDelimiter) {
        this.multiValueDelimiter = multiValueDelimiter;
    }

    public void setProfilePropertyTypes(Collection<PropertyType> profilePropertyTypes) {
        this.profilePropertyTypes = profilePropertyTypes;
    }
}

