/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.exceptions;

import aQute.lib.exceptions.Exceptions;
import java.util.Objects;
import java.util.function.Supplier;

@FunctionalInterface
public interface SupplierWithException<R> {
    public R get() throws Exception;

    default public Supplier<R> orElseThrow() {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    default public Supplier<R> orElse(R orElse) {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                return orElse;
            }
        };
    }

    default public Supplier<R> orElseGet(Supplier<? extends R> orElseGet) {
        Objects.requireNonNull(orElseGet);
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                return orElseGet.get();
            }
        };
    }

    public static <R> Supplier<R> asSupplier(SupplierWithException<R> unchecked) {
        return unchecked.orElseThrow();
    }

    public static <R> Supplier<R> asSupplierOrElse(SupplierWithException<R> unchecked, R orElse) {
        return unchecked.orElse(orElse);
    }

    public static <R> Supplier<R> asSupplierOrElseGet(SupplierWithException<R> unchecked, Supplier<? extends R> orElseGet) {
        return unchecked.orElseGet(orElseGet);
    }
}

