/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.nio.CharBuffer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;

public class ParsedStringTerms
extends ParsedTerms {
    private static ObjectParser<ParsedStringTerms, Void> PARSER = new ObjectParser(ParsedStringTerms.class.getSimpleName(), true, ParsedStringTerms::new);

    @Override
    public String getType() {
        return "sterms";
    }

    public static ParsedStringTerms fromXContent(XContentParser parser, String name) throws IOException {
        ParsedStringTerms aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedStringTerms.declareParsedTermsFields(PARSER, ParsedBucket::fromXContent);
    }

    public static class ParsedBucket
    extends ParsedTerms.ParsedBucket {
        private BytesRef key;

        @Override
        public Object getKey() {
            return this.getKeyAsString();
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return this.key.utf8ToString();
            }
            return null;
        }

        @Override
        public Number getKeyAsNumber() {
            if (this.key != null) {
                return Double.parseDouble(this.key.utf8ToString());
            }
            return null;
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKey());
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseTermsBucketXContent(parser, ParsedBucket::new, (p, bucket) -> {
                CharBuffer cb = p.charBufferOrNull();
                bucket.key = cb == null ? null : new BytesRef((CharSequence)cb);
            });
        }
    }
}

