/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.parameter.CombinedRequestParametersAdapter;
import org.apache.wicket.request.parameter.EmptyRequestParameters;
import org.apache.wicket.request.parameter.UrlRequestParametersAdapter;

public abstract class Request {
    public abstract Url getUrl();

    public abstract Url getClientUrl();

    public Url getOriginalUrl() {
        return this.getUrl();
    }

    public IRequestParameters getPostParameters() {
        return EmptyRequestParameters.INSTANCE;
    }

    public IRequestParameters getQueryParameters() {
        return new UrlRequestParametersAdapter(this.getUrl());
    }

    public IRequestParameters getRequestParameters() {
        return new CombinedRequestParametersAdapter(this.getPostParameters(), this.getQueryParameters());
    }

    public abstract Locale getLocale();

    public Request cloneWithUrl(final Url url) {
        return new Request(){

            @Override
            public Url getUrl() {
                return url;
            }

            @Override
            public Url getOriginalUrl() {
                return Request.this.getOriginalUrl();
            }

            @Override
            public Locale getLocale() {
                return Request.this.getLocale();
            }

            @Override
            public IRequestParameters getPostParameters() {
                return Request.this.getPostParameters();
            }

            @Override
            public Charset getCharset() {
                return Request.this.getCharset();
            }

            @Override
            public Url getClientUrl() {
                return Request.this.getClientUrl();
            }

            @Override
            public Object getContainerRequest() {
                return Request.this.getContainerRequest();
            }
        };
    }

    public String getPrefixToContextPath() {
        return "";
    }

    public String getContextPath() {
        return "";
    }

    public String getFilterPath() {
        return "";
    }

    public abstract Charset getCharset();

    public abstract Object getContainerRequest();
}

