/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ceph;

import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ceph.CephTestBase;

public class TestCephCustomReplication
extends CephTestBase {
    public void testCustomReplication() throws Exception {
        String[] pools = this.getConfiguredDataPools();
        TestCephCustomReplication.assertTrue((pools.length > 0 ? 1 : 0) != 0);
        boolean i = false;
        for (String pool : pools) {
            int repl = this.getPoolReplication(pool);
            Path path = new Path("/file.custom.repl." + pool + "." + repl);
            System.out.println("path " + path + " pool " + pool + " repl " + repl);
            FSDataOutputStream out = this.fs.create(path, false, 4096, (short)repl, this.fs.getDefaultBlockSize());
            out.write(this.data, 0, this.data.length);
            out.close();
            FileStatus status = this.fs.getFileStatus(path);
            TestCephCustomReplication.assertTrue((status.getReplication() == repl ? 1 : 0) != 0);
            this.fs.delete(path);
        }
    }
}

