################################################################################
#
# Beagle Pup Messages
#
# Copyright (c) 2015 Richard Senior
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301, USA.
#
################################################################################

var status = screen.window.new(0, 0, 1, 5);

var message = func(s)
{
    var night = getprop("sim/time/sun-angle-rad") > 1.6;
    var level = night ? 0.6 : 0.1;
    status.fg = [level, level, level, 1.0];
    status.write(s);
}

setlistener("autopilot/locks/heading-hold", func(node) {
    if (node.getBoolValue()) {
        var h = getprop("autopilot/internal/target-heading-deg");
        message(sprintf("Heading Hold: %.0f deg", h));
    }
}, 0, 0);

setlistener("autopilot/sperry/elev-trim", func(node) {
    message(sprintf("Elev Trim: %.2f deg", node.getValue()));
}, 0, 0);

setlistener("autopilot/sperry/pitch-select", func(node) {
    message(sprintf("Pitch Select: %.1f deg", node.getValue()));
}, 0, 0);

setlistener("autopilot/sperry/roll-trim", func(node) {
    message(sprintf("Roll Trim: %.2f deg", node.getValue()));
}, 0, 0);

setlistener("autopilot/sperry/turn-select", func(node) {
    message(sprintf("Turn Select: %.0f deg", node.getValue()));
}, 0, 0);

setlistener("instrumentation/adf/rotation-deg", func(node) {
    message(sprintf("ADF: %.0f", node.getValue()));
}, 0, 0);

setlistener("controls/anti-ice/engine/carb-heat-norm", func(node) {
    message(sprintf("Carb Heat: %.0f%%", 100 * node.getValue()));
}, 0, 0);

setlistener("instrumentation/altimeter/setting-inhg", func(node) {
    var hpa = math.round(getprop("instrumentation/altimeter/setting-hpa"));
    message(sprintf("Altimeter: %.2f inHg or %.0f hPa", node.getValue(), hpa));
}, 0, 0);

setlistener("instrumentation/nav/radials/selected-deg", func(node) {
    message(sprintf("Radial: %.0f", node.getValue()));
}, 0, 0);

################################################################################
# Crash detection
################################################################################

var report_crash = func(msg)
{
    # Don't report multiple crashes. The crash detection system will
    # set sim/crashed when it detects the first one.
    if (getprop("sim/crashed"))
        return;

    setprop("sim/messages/ai-plane", msg);
    printlog("alert", msg);
}

var start_crash_reporting = func
{
    var crash = "fdm/jsbsim/systems/crash-detect/";

    setlistener(crash~"heavy-impact", func(node) {
        if (node.getBoolValue())
            report_crash("Impact on the aircraft.");
    }, 0, 0);

    setlistener(crash~"wing-strike", func(node) {
        if (node.getBoolValue())
            report_crash("Impact on one of the main wings.");
    }, 0, 0);

    setlistener(crash~"tail-strike", func(node) {
        if (node.getBoolValue())
            report_crash("Impact on part of the tail.");
    }, 0, 0);

    setlistener(crash~"fuselage-strike", func(node) {
        if (node.getBoolValue())
            report_crash("Impact on part of the fuselage.");
    }, 0, 0);

    setlistener(crash~"propeller-strike", func(node) {
        if (node.getBoolValue())
            report_crash("Impact on the propeller.");
    }, 0, 0);
}

setlistener("sim/signals/fdm-initialized", func(node) {
    if (node.getBoolValue())
        start_crash_reporting();
}, 0, 0);

