# This file is part of FlightGear, the free flight simulator
# http://www.flightgear.org/
#
# Copyright (C) 2010 Dave Perry, skidavem (at) mindspring _dot_ com#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

# Based on Pa24 nas file

var value = 0;
var test = 0;
var toggle = 0;

var fuel_switch = func(rotDir) {
  node = props.globals.getNode("consumables/fuel/tank[0]/selected",0);
  #node.setBoolValue(0);
  node = props.globals.getNode("consumables/fuel/tank[1]/selected",0);
  #node.setBoolValue(0);
  node = props.globals.getNode("consumables/fuel/tank[2]/selected",0);
  #node.setBoolValue(0);
  node = props.globals.getNode("consumables/fuel/tank[3]/selected",0);
  #node.setBoolValue(0);

  val = getprop("controls/fuel/switch-position");
  test = rotDir + val;
  if(test > 4){test=0};
  if(test < 0){test=4};
  setprop("controls/fuel/switch-position",test);
  if(test == 1){
    node = props.globals.getNode("consumables/fuel/tank[0]/selected",0);
    node.setBoolValue(1);
    if(getprop("consumables/fuel/tank[0]/level-gal_us")>0.01){
      node = props.globals.getNode("engines/engine/out-of-fuel",1);
      node.setBoolValue(0);
    } 
  }
  if(test == 2){
    node = props.globals.getNode("consumables/fuel/tank[1]/selected",0);
    node.setBoolValue(1);
    if(getprop("consumables/fuel/tank[1]/level-gal_us")>0.01){
      node = props.globals.getNode("engines/engine/out-of-fuel",1);
      node.setBoolValue(0);
    } 
  }
  if(test == 3){
    node = props.globals.getNode("consumables/fuel/tank[2]/selected",0);
    node.setBoolValue(1);
    if(getprop("consumables/fuel/tank[2]/level-gal_us")>0.01){
      node = props.globals.getNode("engines/engine/out-of-fuel",1);
      node.setBoolValue(0);
    } 
  }
  if(test == 4){
    node = props.globals.getNode("consumables/fuel/tank[3]/selected",0);
    node.setBoolValue(1);
    if(getprop("consumables/fuel/tank[3]/level-gal_us")>0.01){
      node = props.globals.getNode("engines/engine/out-of-fuel",1);
      node.setBoolValue(0);
    } 
  }
}

setprop("controls/fuel/switch-position", -1);
fuel_switch(1);

var master_switch = func {
  toggle=getprop("controls/electric/battery-switch");
  toggle=1-toggle;
  setprop("controls/electric/battery-switch",toggle);
  click.setBoolValue(1);
}

var f_pump_switch = func {
  toggle=getprop("controls/engines/engine/fuel-pump");
  toggle=1-toggle;
  setprop("controls/engines/engine/fuel-pump",toggle);
  click.setBoolValue(1);
}

var panel_light_switch = func(c) {
  var factor = getprop("controls/switches/panel-lights-factor");
  if ( (c > 0) and ( factor > 1 )) { factor = 1; return; } 
  if ( (c < 0) and ( factor < 0 )) { factor = 0; return; }
  factor = c*0.01 + factor;
  setprop("controls/switches/panel-lights-factor",factor);
  if (factor > 0.0001 ) { toggle = 1; }
  else { toggle = 0; }
  var lastToggle = getprop("controls/switches/nav-lights");
  if ( toggle != lastToggle ) {
     setprop("controls/switches/nav-lights",toggle);
     click.setBoolValue(1);
  }
}

var landing_light_switch_left = func {
  toggle=getprop("controls/switches/landing-light-L");
  toggle=1-toggle;
  setprop("controls/switches/landing-light-L",toggle);
  click.setBoolValue(1);
}

var landing_light_switch_right = func {
  toggle=getprop("controls/switches/landing-light-R");
  toggle=1-toggle;
  setprop("controls/switches/landing-light-R",toggle);
  click.setBoolValue(1);
}

var landing_light_switch_both = func {
#    SLAVE the Right switch to the Left switch
  toggle=getprop("controls/switches/landing-light-L");
  toggle=1-toggle;
  setprop("controls/switches/landing-light-L",toggle);
  setprop("controls/switches/landing-light-R",toggle);
  click.setBoolValue(1);
}

var turn_bank_switch = func {
  toggle = getprop("controls/switches/turn-indicator");
  toggle=1-toggle;
  setprop("controls/switches/turn-indicator",toggle);
  click.setBoolValue(1);
}

var rot_beacon_switch = func {
  toggle=getprop("controls/switches/flashing-beacon");
  toggle=1-toggle;
  setprop("controls/switches/flashing-beacon",toggle);
  click.setBoolValue(1);
}

var pitot_heat_switch = func {
  toggle=getprop("controls/anti-ice/pitot-heat");
  toggle=1-toggle;
  setprop("controls/anti-ice/pitot-heat",toggle);
  click.setBoolValue(1);
}

var strobe_light_switch = func {
  toggle=getprop("controls/switches/strobe-lights");
  toggle=1-toggle;
  setprop("controls/switches/strobe-lights",toggle);
  click.setBoolValue(1);
}

var avionics_master_switch = func {
  toggle=getprop("controls/switches/master-avionics");
  toggle=1-toggle;
  setprop("controls/switches/master-avionics",toggle);
  click.setBoolValue(1);
}

var carb_heat = func {
  toggle=getprop("controls/anti-ice/engine/carb-heat");
  toggle=1-toggle;
  setprop("controls/anti-ice/engine/carb-heat",toggle);
}

var primer = func {
  toggle=getprop("controls/engines/engine/primer-pump");
  toggle=1-toggle;
  setprop("controls/engines/engine/primer-pump",toggle);
  prime.setBoolValue(1);
}

var map_light_switch = func {
  toggle=getprop("controls/switches/map-lights");
  toggle=1-toggle;
  setprop("controls/switches/map-lights",toggle);
}

var cabin_light_switch = func {
  toggle=getprop("controls/switches/cabin-lights");
  toggle=1-toggle;
  setprop("controls/switches/cabin-lights",toggle);
}

var oat_switch = func {
  val = getprop("controls/switches/oat-switch");
  test = 1 + val;
  if(test > 2){test=0};
  setprop("controls/switches/oat-switch",test);
  settimer(oat_off, 300);
}

var oat_off = func {
  setprop("controls/switches/oat-switch",0);
}
