##########################################################
##	DHC8 Engine instruments and ALT Preselect	##
##########################################################

##	Setup Properties
var alt_preselect = props.globals.getNode("it-autoflight/input/alt", 1);
var engine_properties = {
	trq: [
		props.globals.getNode("engines/engine[0]/thruster/torque-pct", 1),
		props.globals.getNode("engines/engine[1]/thruster/torque-pct", 1),
	],
	rpm: [
		props.globals.getNode("engines/engine[0]/thruster/rpm", 1),
		props.globals.getNode("engines/engine[1]/thruster/rpm", 1),
	],
	itt: [
		props.globals.getNode("engines/engine[0]/itt_degc", 1),
		props.globals.getNode("engines/engine[0]/itt_degc", 1),
	],
	nh: [
		props.globals.getNode("engines/engine[0]/n2", 1),
		props.globals.getNode("engines/engine[1]/n2", 1),
	],
	ff: [
		props.globals.getNode("engines/engine[0]/fuel-flow_kgph", 1),
		props.globals.getNode("engines/engine[1]/fuel-flow_kgph", 1),
	],
	nl: [
		props.globals.getNode("engines/engine[0]/n1", 1),
		props.globals.getNode("engines/engine[1]/n1", 1),
	],
};


var lcd_display = {
	new: func ( name, property_node, placement, sprintf_string ) {
		var m = {	parents: [ lcd_display ],
				name: name,
				canvas: canvas.new({
					"name": name,
					"size": [ 256, 64 ],
					"view": [ 256, 64 ],
					"mipmapping": 1,
					}),
				property: property_node,
				text: nil,
				sprintf_string: sprintf_string,
		};
		m.canvas.addPlacement({"node": placement});
		m.text = m.canvas.createGroup()
					.createChild("text", name~".text")
					.setTranslation( 128, 32 )
					.setAlignment("center-center")
					.setFont("7-Segment.ttf")
					.setFontSize( 18 )
					.setColor( 0.9, 0.4, 0.1 )
					.setText( sprintf( sprintf_string, m.property.getDoubleValue() ) );
		
		return m;
	},
	updateValue: func {
		me.text.setText( sprintf( me.sprintf_string, me.property.getDoubleValue() ) );
	},
};

#	Make Displays
var alt_display = lcd_display.new( "ALT Preselect", alt_preselect, "altset.display", "%5d" );
alt_display.text.setFontSize( 26 );

setlistener( alt_display.property, func() { alt_display.updateValue() } );

var engine_instruments = {
	trq: [
		lcd_display.new( "TRQ0", engine_properties.trq[0], "trq0.display", "%4.1f" ),
		lcd_display.new( "TRQ1", engine_properties.trq[1], "trq1.display", "%4.1f" ),
	],
	rpm: [
		lcd_display.new( "RPM0", engine_properties.rpm[0], "rpm0.display", "%4d" ),
		lcd_display.new( "RPM1", engine_properties.rpm[1], "rpm1.display", "%4d" ),
	],
	itt: [
		lcd_display.new( "ITT0", engine_properties.itt[0], "itt0.display", "%4d" ),
		lcd_display.new( "ITT1", engine_properties.itt[1], "itt1.display", "%4d" ),
	],
	nh: [
		lcd_display.new( "NH0", engine_properties.nh[0], "nh0.display", "%5.1f" ),
		lcd_display.new( "NH1", engine_properties.nh[1], "nh1.display", "%5.1f" ),
	],
	ff: [
		lcd_display.new( "FF0", engine_properties.ff[0], "ff0.display", "%3d" ),
		lcd_display.new( "FF1", engine_properties.ff[1], "ff1.display", "%3d" ),
	],
	nl: [
		lcd_display.new( "NL0", engine_properties.nl[0], "nl0.display", "%5.1f" ),
		lcd_display.new( "NL1", engine_properties.nl[1], "nl1.display", "%5.1f" ),
	],
};

var eng_instr_updater = maketimer( 0.1, func () {
	foreach( var el; keys( engine_instruments ) ){
		foreach( var instr; engine_instruments[ el ] ){
			instr.updateValue();
		}
	}
});
eng_instr_updater.simulatedTime = 1;
eng_instr_updater.start();
