#		KT76a Transponder Simulation
#
#			11/2023 Bea Wolf
#
var internal_state = 0;		# 0 = OFF, 1 = WARM UP, 2 = READY

var xpdr_mode   		= props.globals.getNode( "/instrumentation/transponder/inputs/knob-mode", 1); # 0 = OFF, 1 = STANDBY
var xpdr_reply  		= aircraft.light.new(    "/instrumentation/transponder/reply", [0.1, 12.0]);
var xpdr_reply_ind 	= props.globals.initNode("/instrumentation/transponder/reply-lamp", 0, "BOOL");
var xpdr_ident_btn 	= props.globals.getNode( "/instrumentation/transponder[0]/inputs/ident-btn", 1);
var xpdr_ident		= props.globals.getNode( "/instrumentation/transponder[0]/ident", 1);
var xpdr_volts  		= props.globals.getNode( "/systems/electrical/outputs/transponder[0]");

var xpdr_loop = func{
	if( xpdr_mode.getIntValue() > 0 and xpdr_volts.getDoubleValue() > 9.0 ){
		if( internal_state == 0 ) {
			internal_state = 1;
			xpdr_state_timer.start();
		} elsif( internal_state == 2 ){
			if(xpdr_mode.getIntValue() > 2 ){
				xpdr_reply.switch( 1 );
			} else {
				xpdr_reply.switch( 0 );
			}
		}
	} else {
		if( internal_state != 0 ){
			internal_state = 0;
			xpdr_reply.switch( 0 );
		}
	}
}

var xpdr_timer = maketimer( 0.2, xpdr_loop );
xpdr_timer.simulatedTime = 1;
xpdr_timer.start();

var xpdr_state_timer = maketimer( 45.0, func{ internal_state = 2; } );
xpdr_state_timer.simulatedTime = 1;
xpdr_state_timer.singleShot = 1;

setlistener( xpdr_reply.stateN, func{
	if( xpdr_reply.stateN.getBoolValue() ){
		xpdr_reply_ind.setBoolValue( 1 );
	} elsif( !xpdr_ident.getBoolValue() and xpdr_mode.getIntValue() != 2 ){
		xpdr_reply_ind.setBoolValue( 0 );
	}
});

setlistener( xpdr_ident, func{
	if( xpdr_ident.getBoolValue() ){
		xpdr_reply_ind.setBoolValue( 1 );
	} elsif( !xpdr_reply.stateN.getBoolValue() and xpdr_mode.getIntValue() != 2 ){
		xpdr_reply_ind.setBoolValue( 0 );
	}
});

setlistener( xpdr_mode, func{
	if( xpdr_mode.getIntValue() == 2 ){
		xpdr_reply_ind.setBoolValue( 1 );
	} elsif( !xpdr_reply.stateN.getBoolValue() and !xpdr_ident.getBoolValue() ){
		xpdr_reply_ind.setBoolValue( 0 );
	}
});

var reset_ident_timer = maketimer( 18.0, func{ xpdr_ident.setBoolValue( 0 ); } );
reset_ident_timer.simulatedTime = 1;
reset_ident_timer.singleShot = 1;

setlistener( xpdr_ident_btn, func{
	if( xpdr_ident_btn.getBoolValue() and !xpdr_ident.getBoolValue() ){
		xpdr_ident.setBoolValue( 1 );
		reset_ident_timer.start();
	}
});
