# Becker Transponder FCU by D-ECHO based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var FCU_main = nil;
var FCU_start = nil;
var FCU_display = nil;
var page = "start";

var hp_kw = 0.7457;

var base = "/systems/FES/FCU/";
var inputs = base~"inputs/";

setprop(base~"sq", 1);

var start_prop = base~"start";
var volt_prop = "/systems/electrical/outputs/fcu";
setprop(start_prop, 1);

var eng_rpm = props.globals.getNode("engines/engine[0]/rpm", 1);
var eng_pwr = props.globals.getNode("fdm/jsbsim/propulsion/engine[0]/power-hp", 1);

var batt_volts = props.globals.getNode("/systems/FES/volts", 1);
var batt_amps = props.globals.getNode("/systems/FES/amps", 1);

var throttle = props.globals.getNode("/systems/FES/throttle", 1);

var temp_motor = props.globals.getNode("/systems/FES/temperatures/motor-degc", 1);
var temp_controller = props.globals.getNode("/systems/FES/temperatures/controller-degc", 1);
var temp_battery1 = props.globals.getNode("/systems/FES/temperatures/battery1-degc", 1);
var temp_battery2 = props.globals.getNode("/systems/FES/temperatures/battery2-degc", 1);

var master_switch = props.globals.getNode("/systems/FES/fes-master-switch", 1);

var batt_charge = props.globals.getNode("/systems/FES/battery-charge-pct", 1);

var instrument_dir = "Aircraft/Silent2Electro/Models/Instruments/FCU/";


var canvas_FCU_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = getprop(volt_prop) or 0;
		var start = getprop(start_prop) or 0;
		if ( start == 1 and volt >= 9 ) {
			FCU_start.page.hide();
			FCU_main.page.show();
			FCU_main.update();
		} else if ( start > 0 and start < 1 and volt >= 9){
			FCU_main.page.hide();
			FCU_start.page.show();
		} else {
			FCU_main.page.hide();
			FCU_start.page.hide();
		}
	},
};
	
	
var canvas_FCU_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_FCU_main , canvas_FCU_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm.100","pwr.digits","battery.volts","battery.amps","throttle.bar","battery.1","battery.2","battery.3","battery.4","battery.5","battery.6","battery.7","battery.8","battery.9","battery.10","temp.motor","temp.controller","temp.battery1","temp.battery2","controller.flag"];
	},
	update: func() {
		me["rpm.100"].setText(sprintf("%02d", math.round(math.floor(eng_rpm.getValue()/100))));
		
		var power = eng_pwr.getValue()*hp_kw;
		if(power > 1){
			me["pwr.digits"].setText(sprintf("%2d", math.round(power)));
		}else{
			me["pwr.digits"].setText("--");
		}
		
		var bv = batt_volts.getValue();
		if(bv != nil){
			me["battery.volts"].setText(sprintf("%3d", math.round(bv))~"V");
		}else{
			me["battery.volts"].setText("---V");
		}
		var ba = batt_amps.getValue();
		if(ba != nil and ba > 0){
			me["battery.amps"].setText(sprintf("%3d", math.round(ba))~"A");
		}else{
			me["battery.amps"].setText("---A");
		}
		
		me["throttle.bar"].setTranslation(-(1-throttle.getValue())*292,0);
		
		var charge = batt_charge.getValue();
		
		if(charge > 0.9){
			me["battery.10"].show();
		}else{
			me["battery.10"].hide();
		}
		if(charge > 0.8){
			me["battery.9"].show();
		}else{
			me["battery.9"].hide();
		}
		if(charge > 0.7){
			me["battery.8"].show();
		}else{
			me["battery.8"].hide();
		}
		if(charge > 0.6){
			me["battery.7"].show();
		}else{
			me["battery.7"].hide();
		}
		if(charge > 0.5){
			me["battery.6"].show();
		}else{
			me["battery.6"].hide();
		}
		if(charge > 0.4){
			me["battery.5"].show();
		}else{
			me["battery.5"].hide();
		}
		if(charge > 0.3){
			me["battery.4"].show();
		}else{
			me["battery.4"].hide();
		}
		if(charge > 0.2){
			me["battery.3"].show();
		}else{
			me["battery.3"].hide();
		}
		if(charge > 0.1){
			me["battery.2"].show();
		}else{
			me["battery.2"].hide();
		}
		if(charge > 0.0){
			me["battery.1"].show();
		}else{
			me["battery.1"].hide();
		}
		
		
		me["temp.motor"].setText(sprintf("%2d", math.round(temp_motor.getValue()))~"°C");
		me["temp.controller"].setText(sprintf("%2d", math.round(temp_controller.getValue()))~"°C");
		me["temp.battery1"].setText(sprintf("%2d", math.round(temp_battery1.getValue()))~"°C");
		me["temp.battery2"].setText(sprintf("%2d", math.round(temp_battery2.getValue()))~"°C");
		
	
		if(master_switch.getValue()){
			me["controller.flag"].setText("CONTROLLER READY");
			me["controller.flag"].setColor(0,1,0);
		}else{
			me["controller.flag"].setText("NO DATA FROM CONTROLLER");
			me["controller.flag"].setColor(1,1,1);
		}
	}
	
};



var canvas_FCU_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_FCU_start , canvas_FCU_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};

var identoff = func {
	setprop("/instrumentation/transponder/inputs/ident-btn", 0);
}

setlistener("/instrumentation/transponder/inputs/ident-btn-2", func{
	setprop("/instrumentation/transponder/inputs/ident-btn", 1);
	settimer(identoff, 18);
});


var ls = setlistener("sim/signals/fdm-initialized", func {
	FCU_display = canvas.new({
		"name": "FCU",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	FCU_display.addPlacement({"node": "FCU.display"});
	var groupMain = FCU_display.createGroup();
	var groupStart = FCU_display.createGroup();


	FCU_main = canvas_FCU_main.new(groupMain, instrument_dir~"FCU.main.svg");
	FCU_start = canvas_FCU_start.new(groupStart, instrument_dir~"FCU.start.svg");

	var base_update = maketimer(	0.2, 
					func {
						canvas_FCU_base.update();
					});
	base_update.start();
	removelistener(ls);
});


var identoff = func {
	setprop("/instrumentation/transponder/inputs/ident-btn", 0);
}

var ident_btn = func() {
	setprop("/instrumentation/transponder/inputs/ident-btn", 1);
	settimer(identoff, 18);
}

setlistener(volt_prop, func{
	if(getprop(volt_prop) >= 9 and getprop(start_prop) == 0){
		interpolate(start_prop, 1, 2 );
	}else if( (  getprop(volt_prop) < 9 ) and getprop(start_prop) != 0){
		setprop(start_prop, 0);
	}
});
