#	All Properties and variables used by the aircraft's (nasal-coded) systems 
var electrical = props.globals.getNode( "/systems/electrical", 1 );
var batt = {
	temp: [
		electrical.getNode( "battery-front/temp-degc", 1 ),
		electrical.getNode( "battery-rear/temp-degc", 1 ),
	],
	status: [
		electrical.initNode( "battery-front/status", 0, "INT" ),	# 0 = ERROR; 1 = READY; 2 = ACTIVE
		electrical.initNode( "battery-rear/status", 0, "INT" ),	# 0 = ERROR; 1 = READY; 2 = ACTIVE
	],
	present: [
		props.globals.getNode("/taurus/electro/battery-front-present", 1),
		props.globals.getNode("/taurus/electro/battery-rear-present", 1),
	],
	mass: [
		props.globals.getNode("/fdm/jsbsim/inertia/pointmass-weight-lbs[9]", 1), # todo
		props.globals.getNode("/fdm/jsbsim/inertia/pointmass-weight-lbs[10]", 1), # todo
	],
	heating: [
		props.globals.getNode("/fdm/jsbsim/systems/heating/battery-heating[0]", 1),
		props.globals.getNode("/fdm/jsbsim/systems/heating/battery-heating[1]", 1),
	],
};
var batt_present = [ 1, 1 ];
var dcdc_serv = props.globals.getNode("/systems/electrical/components/dcdc-serviceable", 1);

var engine = {
	thr: props.globals.getNode( "/controls/engines/engine[0]/throttle", 1 ),
	power_hp: props.globals.getNode( "/fdm/jsbsim/propulsion/engine[0]/electrical-power-hp", 1 ),
	rpm: props.globals.getNode( "/engines/engine[0]/rpm", 1 ),
	prop_cmd: props.globals.initNode("/instrumentation/epsi430/position-cmd", 0, "BOOL"),
	prop_cmd_int: props.globals.getNode("/fdm/jsbsim/propulsion/engine[0]/propeller-tower-cmd-norm"),
	sys_en:	props.globals.initNode("/instrumentation/epsi430/system-enable", 0, "BOOL"),
	drive_en: -1,
	prop_pos:	props.globals.initNode("/fdm/jsbsim/propulsion/engine[0]/propeller-tower-pos-norm", 0.0, "DOUBLE"),
};
