var switch_fuelS = func {
  var cockR = getprop ("controls/fuel/stbdcock");
  setprop ("consumables/fuel/tank[1]/selected", 0);
  setprop ("consumables/fuel/tank[3]/selected", 0);
  setprop ("consumables/fuel/tank[5]/selected", 0);

  # inner tanks
  if ( cockR == 1 ) {
    setprop ("consumables/fuel/tank[1]/selected", 1);
    setprop ("consumables/fuel/tank[3]/selected", 1);
  }
  # outer tanks
  if ( cockR == 2 ) {
    setprop ("consumables/fuel/tank[5]/selected", 1);
  }
}

var switch_fuelP = func {
  var cockL = getprop ("controls/fuel/prtcock");
  setprop ("consumables/fuel/tank[0]/selected", 0);
  setprop ("consumables/fuel/tank[2]/selected", 0);
  setprop ("consumables/fuel/tank[4]/selected", 0);

  # inner tanks
  if ( cockL == 1 ) {
    setprop ("consumables/fuel/tank[0]/selected", 1);
    setprop ("consumables/fuel/tank[2]/selected", 1);
  }
  # outer tanks
  if ( cockL == 2 ) {
    setprop ("consumables/fuel/tank[4]/selected", 1);
  }
}

var door = aircraft.door.new ("/controls/doors/door/",2.5);

var bombbaydoor = aircraft.door.new ("/controls/armament/bombbaydoor/",3.5);

aircraft.livery.init("Aircraft/mosquito/Models/Liveries", "sim/model/livery/name");

var config = gui.Dialog.new("/sim/gui/dialogs/appearance/dialog", "Aircraft/mosquito/Dialogs/config.xml");

var save_list = ["/combat/enabled",
                 "/controls/startup/idling",
                 "/controls/startup/config"];
aircraft.data.add(save_list);

var flash_trigger = props.globals.getNode("sim/armament/gun[0]/fire", 0);
aircraft.light.new("sim/model/mosquito/lighting/flash-l", [0.03, 0.02], flash_trigger);
aircraft.light.new("sim/model/mosquito/lighting/flash-r", [0.024, 0.03], flash_trigger);

var cannon_trigger = props.globals.getNode("sim/armament/cannon[0]/fire", 0);
aircraft.light.new("sim/model/mosquito/lighting/flash-l", [0.03, 0.02], cannon_trigger);
aircraft.light.new("sim/model/mosquito/lighting/flash-r", [0.024, 0.03], cannon_trigger);


set_drop_tank_capacity = func (capacity_impgal) {
  setprop ("/consumables/fuel/tank[6]/capacity-gal_imp", capacity_impgal);
  setprop ("/consumables/fuel/tank[7]/capacity-gal_imp", capacity_impgal);
  setprop ("/consumables/fuel/tank[6]/level-gal_imp", capacity_impgal);
  setprop ("/consumables/fuel/tank[7]/level-gal_imp", capacity_impgal);
  setprop ("/consumables/fuel/tank[6]/selected", capacity_impgal != 0);
  setprop ("/consumables/fuel/tank[7]/selected", capacity_impgal != 0);
  setprop ("controls/fuel/stbdcock", 0); switch_fuelS ();
  setprop ("controls/fuel/prtcock", 0);  switch_fuelP ();
}

select_drop_tanks = func (drop_tank_type) {
  setprop ("/sim/armament/bombL/type", 0);
  setprop ("/sim/armament/bombR/type", 0);
  setprop ("/sim/armament/tankL/type", drop_tank_type);
  setprop ("/sim/armament/tankR/type", drop_tank_type);
  if (drop_tank_type == 0) {
    set_drop_tank_capacity (0);
  }
  else if (drop_tank_type == 2) {
    set_drop_tank_capacity (50);
  }
  else if (drop_tank_type == 3) {
    set_drop_tank_capacity (100);
  }
  else if (drop_tank_type == 4) {
    set_drop_tank_capacity (200);
  }
}


jettison_drop_tanks = func () {
  var type = getprop ("sim/armament/tankL/type");
  if (type == 0) return;
  # we save and restore the fuel cocks because select_drop_tanks closes them.
  var cocks = [ getprop ("controls/fuel/prtcock"), getprop ("controls/fuel/stbdcock") ];
  select_drop_tanks (0);
  setprop ("controls/fuel/prtcock",  cocks[0]);
  setprop ("controls/fuel/stbdcock", cocks[1]);
  switch_fuelP();
  switch_fuelS();
  # Trigger the appropriate submodels:
  if (type == 2) setprop ("controls/fuel/droptank-50/jettison", 1);
  if (type == 3) setprop ("controls/fuel/droptank-100/jettison", 1);
  if (type == 4) setprop ("controls/fuel/droptank-200/jettison", 1);
}


# Capture the current altitude into the autopilot target altitude, whenever alt-hold mode is engaged
var capture_altitude_listener = setlistener ("autopilot/locks/altitude", func (lock)
{
    if (lock.getValue () == "altitude-hold") {
        var a = math.round (getprop ("position/altitude-ft"));
        setprop("autopilot/settings/target-altitude-ft", a);
    }
}, startup=0, runtime=0);


# Capture the current heading into the autopilot target heading whenever heading-hold is engaged
var capture_heading_listener = setlistener ("autopilot/locks/heading", func (lock)
{
    if (lock.getValue () == "dg-heading-hold") {
        setprop ("autopilot/settings/heading-bug-deg",
                 getprop ("instrumentation/heading-indicator/indicated-heading-deg"));
    }
}, startup=0, runtime=0);


# Compute range remaining every second
var endurance   = props.globals.initNode ("/consumables/fuel/endurance-remaining", 1, "STRING");
var range       = props.globals.initNode ("/consumables/fuel/range-remaining-nmi", 1, "DOUBLE");
var range_total = props.globals.initNode ("/consumables/fuel/range-total-nmi", 1, "DOUBLE");
var true_speed  = props.globals.initNode ("/instrumentation/airspeed-indicator/true-speed-kt", 1, "DOUBLE");
var odometer    = props.globals.initNode ("/instrumentation/gps/odometer", 1, "DOUBLE");

var fuel_flow_timer = maketimer (1.0, func () {
   var ff_gph = 0;
   for (var engine=0; engine<2; engine+=1) {
      ff_gph += getprop ("/engines/engine[" ~ engine ~ "]/fuel-flow-gph");
   }
   var endurance_h = 0;
   if (ff_gph > 0) { endurance_h = getprop ("consumables/fuel/total-fuel-gal_us") / ff_gph; }
   endurance.setValue (sprintf ("%d:%02d:%02d",
                                int (endurance_h),
                                math.mod (endurance_h * 60, 60),
                                math.mod (endurance_h * 3600, 60)));
   range.setValue (endurance_h * true_speed.getValue ());
   range_total.setValue (range.getValue () + odometer.getValue ());
});

# Start the timer after the FDM is initalized:
var fdm_listener = setlistener ("/sim/signals/fdm-initialized", func () {
  fuel_flow_timer.start ();
  removelistener (fdm_listener);
});


# Make rudder control left/right brake balance, like the real aircraft.
#
var brakes_prop_rudder  = props.globals.getNode('controls/flight/rudder', 1);
var brakes_prop_right   = props.globals.getNode('controls/gear/brake-right', 1);
var brakes_prop_left    = props.globals.getNode('controls/gear/brake-left', 1);
var brakes_timer        = maketimer( 0.1, func { brakes_update()});

var brakes_set = func(left, right) {
    # Brakes don't react instantly.
    var rate = 1;
    interpolate(brakes_prop_left,  left, rate);
    interpolate(brakes_prop_right, right, rate);
}
var brakes_update = func() {
    var rudder = brakes_prop_rudder.getValue();
    var left = 1 - rudder;
    if (left > 1) left = 1;
    var right = 1 + rudder;
    if (right > 1) right = 1;
    brakes_set(left, right);
};

var brakes_on = func() {
    brakes_timer.start();
}

var brakes_off = func() {
    brakes_timer.stop();
    brakes_set(0, 0);
}
